﻿

label splashscreen:
    show white
    pause 0.5
    play sound "sound/jingle.ogg"
    show logo1:
        xalign 0.5 yalign 0.5
    with Dissolve(0.4)
    show logo2:
        xalign 0.5 yalign 0.5
    with Dissolve(0.4)
    show logo3:
        xalign 0.5 yalign 0.5
    with Dissolve(0.6)
    show logo4:
        xalign 0.5 yalign 0.5
    with Dissolve(0.6)
    $ renpy.pause(1.5)

    scene white with Dissolve(1)
    show bellhouse:
        xalign 0.5 yalign 0.5
    with Dissolve(.5)
    $ renpy.pause(1.5)
    hide bellhouse
    with Dissolve(0.2)
    show expsyle:
        zoom 0.6
        xalign 0.5
        yalign 0.5
    with Dissolve(.5)
    $ renpy.pause(1.5)
    stop sound fadeout 2
    scene black with Dissolve(1.5)

    python:
        if not persistent.set_volumes:
            persistent.set_volumes = True
            
            _preferences.volumes['music'] *= .6
            _preferences.volumes['sfx'] *= .7

    stop sound

    return
screen content_help():
    text "\nЭто не полный список того, с чем вы можете столкнуться в игре, но и не обязательно всё это сразу выльется на вас за одно прохождение. Пожалуйста, будьте осторожны.\n" text_align 0.5 xalign 0.5
    text "• Насилие"
    text "• Изображения мёртвых, искалеченных или окровавленных персонажей"
    text "• Гомосексуализм"
    text "• Созависимость"
default full_list = False
default beta_test = False
label start:

    $ renpy.clear_game_runtime()

    $ beta_test = False

    play music "sound/madbox.ogg" fadeout 1

    scene black
    with Dissolve(2)

    jump day1
screen content_warning():
    vbox:
        xalign 0.5 ypos 0.15 xsize 995
        text "{size=+15}{font=DejaVuSans.ttf}⚠{/font} Небезопасное содержимое {font=DejaVuSans.ttf}⚠{/font}{/size}\n" text_align 0.5 xalign 0.5
        text "Пожалуйста, помните, что в данной игре могут раскрываться темы, к которым вы можете быть не готовы.\n" text_align 0.5 xalign 0.5
        vbox:
            if not full_list:
                textbutton "Подробнее + " action SetScreenVariable("full_list",True)
            else:
                textbutton "Подробнее - " action SetScreenVariable("full_list",False)
                use content_help
    hbox:
        yalign 0.95 xalign 0.5
        textbutton "Закрыть" action SetField(persistent,"first_warning",True),Return()

label day1:
    if not persistent.first_warning:
        call screen content_warning
    show screen quick_menu
    with dissolve

    $ save_name = "День первый"

    window hide None

    poem "\n\n\n{w=0.5}Коль уготовила тебе судьба лишения и горе," with Dissolve(0.5)
    poem "Ты можешь браво превзмогать, и проложить путь свой."
    poem "Но не изменится исход от пройденной тобой дороги:"
    poem "Ты лишь гуляешь в лабиринте, построенном судьбой."
    play sound "sound/thump.ogg"
    poem "\n\n{size=+15}{cps=10}День первый.{/cps}{/size}"

    nvl clear

    postnvl "{nw}"

    stop music fadeout 2

    scene room with Dissolve(2)
    stop music



    window auto

    "Всё началось одним совершенно непримечательным утром." with dissolve

    "Трагедия, которая вот-вот случится, затронет так мало людей, что про неё все очень быстро забудут."

    "Но вот наших героев этим утром затянет в водоворот событий, который будет сближать их всё сильнее и сильнее..."

    "А зародился сей водоворот весьма безобидно: с одной изгнанной принцессы, оказавшейся в ужаснейшем положении."

    play music "sound/morning.ogg" fadein 2

    show cassidy at top:
        zoom 0.54
    with dissolve

    pause 0.5

    c raised wide unhappyopen2 "...О, боже мой! Дрова закончились."
    c "Если бы только я вчера заметила, что они кончаются."
    c sideeye lowered pout sweatdrop "Какой ужас! Что же теперь делать?"

    "Бывшую принцессу, что стоит перед нами, зовут Кэссиди. Она — старший из наследников королевства Веромир."

    "Что-что? Вы никогда не слышали о Веромире?"
    "Не стоит удивляться этому. Вся эта история произошла задолго до того, как вы появились на свет."

    c down "Новую партию дров привезут ещё не скоро..."

    c sideeye none "Но я не могу ждать! Без огня я не смогу готовить и стирать бельё."

    "Принцесса так долго жила в этом доме одна, что уже привыкла говорить сама с собой, чтоб было не столь одиноко."

    hide cassidy with dis1

    "Полная решимости раздобыть дров до заката, Кэссиди взяла топор и верёвки, и вышла на улицу."

    scene exteriorhouse with area_move
    pause 0.5


    "Снаружи она остановилась, некоторое время размышляя, так ли ей необходимо закрывать за собой дверь на замок."

    show cassidy closed2 sweatdrop catface sad at top:
        zoom 0.54
    with dissolve

    c "...Всё равно никто не придёт сюда. Люди моего брата всё равно не будут входить, а больше никто так глубоко в лес и не заходит."

    "Убедив себя таким образом, Кэссиди отправилась в чащу леса."

    scene forest:
        xalign 1.0
    with area_move

    "К несчастью, её воля и решительность довольно быстро дали слабину."

    show cassidy mismatched narrowed frown sweatdrop at topright:
        zoom 0.54
    with dissolve

    c "Хм. Как я и думала, дрова не валяются просто так на земле..."

    "Хоть она и взяла с собой топор, принцесса тщетно надеялась, что ей не придётся им воспользоваться."
    "И она не знала, с чего начать. Перед ней стояло так много разных деревьев, и в основном довольно больших."

    show black behind cassidy:
        alpha 0.5
    show cassidy glow
    with dissolve

    c_t lowered sideeye lipbite "Надо подумать, сколько дров мне {i}на самом деле{/i} нужно?.."
    c_t sweat closed1 fierce frown "Ох, чем больше я думаю об этом, тем меньше понимаю, сколько же в итоге!"
    c_t "Может, мне просто питаться одними фруктами и грибами, пока дрова не привезут..."

    show cassidy normal
    hide black
    with dis1

    "Но эти мысли были незамедлительно развеяны голодным урчанием в животе принцессы."

    show cassidy sad unhappyopen2 -sweat with dis

    "Кэссиди вздохнула."

    c narrowed happyopen lowered "Ладно, тогда для начала прогуляюсь до своего любимого места... В нём я обретаю покой."
    c neutral closed1 smile1 "Я всегда ощущала что-то магическое в этом месте. Я уверена, что когда приду туда, то сразу же что-нибудь придумаю."

    hide cassidy with dis1

    "Воодушевлённая, Кэссиди приподняла повыше на плечах свой льняной рюкзачок."
    "Она думала о том, что совсем скоро ей вновь будет спокойно и уютно."

    play music "sound/solace.ogg" fadeout 2

    scene forest:
        xalign 0.0
    with area_move

    show cassidy raised open happyopen2 blush at top:
        zoom 0.54
    with dissolve

    c "Ах, тут всё так же прекрасно, как и всегда!"

    "В лесу было множество мест, видом которых можно было бы наслаждаться, но именно это место так сильно радовало принцессу."
    "И хотя она уже прожила здесь не один год, дерево, что стояло перед ней, никогда не менялось."

    c unhappyopen sideeye none "Я не так много знаю о вистериях. Должны ли они цвести круглый год?"
    c "Может, здесь достаточно тёплые зимы для неё."
    c neutral closed1 unhappyopen2 "{i}Вистерия не опадает снежною зимою.{/i}"
    c "{i}Но всё однажды умирает, природы исполняя волю.{/i}"

    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy

    e_first "Но не над всеми обладает природа властью таковою."

    $ hide_alpha = 0
    hide screen fake_cassidy

    show cassidy wide raised unhappyopen with dis
label cg1_for_minute:
    "Звонкий, ясный голос привлёк внимание Кэссиди."
    show first meeting1
    show first meeting2
    show first meeting3
    show first meeting4
    scene first meeting1 with Dissolve(2):
        zoom 1.25 yalign 1.0 xalign 0.5 subpixel True
        ease 10 yalign 0.5 zoom 1.0

    "Сердце принцессы подскочило к горлу, она обернулась на звук и увидела под деревом девичий силуэт."
    "Никогда ещё она не видела столь прекрасной девушки."

    $ met_elowen = False
    show first meeting1:
        ease 2.5 yalign 0.5 zoom 1.0
    e_first "Прошу прощения за то, что помешала вам читать поэму, мадам."
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen



    c "Это... это был всего лишь куплет! Вы нисколько не помешали, наоборот, дополнили его."
    hide screen fake_elowen
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e_first "Вот как? Тогда хорошо. Но всё же не советую вам здесь задерживаться. Так глубоко в лесу — опасно."
    hide screen fake_cassidy
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c "Но я живу здесь! И уверяю вас, здесь вполне безопасно."
    hide screen fake_elowen
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e_first "Позволю себе сказать, что я здесь живу гораздо дольше, чем вы."
    hide screen fake_cassidy
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c "Мне ни разу в этом лесу ничего не навредило. Возможно, мы совершенно по-разному живём."
    hide screen fake_elowen
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e_first "...Определённо. И я принимаю твою точку зрения."

    $ hide_alpha = 0
    hide screen fake_cassidy

    "Кэссиди сделала долгую паузу, задумавшись о том, как лучше продолжить разговор."

    c_t "Как странно... При дворе я совершенно свободно общалась со всеми! Неужели я действительно так сильно изменилась за время пребывания здесь?"

    c "Так... вы говорите, что живёте здесь?"
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e_first "Именно."
    hide screen fake_cassidy
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c "Но я вас никогда не видела! Совершенно точно. Такую, как вы, я бы обязательно запомнила."
    c "Позвольте поинтересоваться, где вы живёте?"
    hide screen fake_elowen
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e_first "В паре шагов от того места, где вы сейчас."
    $ hide_alpha = 0
    hide screen fake_cassidy
    hide screen fake_elowen

    menu:
        c_t_choice "В паре шагов?"
        with ctransition
        "Как это так?":
            $ chosen_text = "Как это так?"
            show screen chosen
            pause 1
            hide screen chosen
            $ u_pts += 1
            c_t "Полагаю, она не хочет рассказывать о своём доме незнакомцу. Вполне разумно."
            c_t "Заметно, что она проявляет осторожность."
            c "Я вам завидую — тут так красиво!"
            $ hide_alpha = 1
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            e_first "...Не советую завидовать мне."
            $ hide_alpha = 0
            hide screen fake_cassidy
            c_t "Что бы это значило? Чудно как."
        "Это очень подозрительно.":

            $ chosen_text = "Это очень подозрительно."
            show screen chosen2
            pause 2
            hide screen chosen2
            $ u_pts = 0
            c_t "Я исследовала округу на протяжении долгого времени, и не видела никаких домов."
            c_t "И выражается она не прямо. Что она может иметь в виду? Не понимаю."
            c "...А такое может быть?"
            $ hide_alpha = 1
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            e_first "Вы обвиняете меня во лжи?"
            hide screen fake_cassidy
            $ fake_e_text = _last_say_what
            show screen fake_elowen
            c "Нет... Я просто—"
            hide screen fake_elowen
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            e_first "Я бы {i}никогда{/i} не соврала. Вообще говоря, я не способна врать."
            $ hide_alpha = 0
            hide screen fake_cassidy
            c_t "Ну вот, теперь она ещё сильнее зажата. Что же я наделала?"
            $ happenings.append("1")

    c "Ой! Где же мои манеры? Меня зовут Кэссиди. Я, как и вы, живу здесь неподалёку."
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    $ met_elowen = True
    e "Можешь звать меня Элоўэн."
    hide screen fake_cassidy
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c "Элоўэн..."
    $ fake_e_text = ""
    hide screen fake_elowen
    c_t "Какое прекрасное имя..."
    e "И да, я уже знаю, что ты живёшь тут рядом."
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c "Как? Откуда?"
    hide screen fake_elowen
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e "Я видела тебя ранее. Издалека, правда. Ты сюда часто приходишь."
    hide screen fake_cassidy
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c "О боже, я, должно быть, выглядела тогда совсем дурочкой."
    c "Прошу прощения, что вам пришлось узреть меня в таком состоянии."
    $ hide_alpha = 0
    hide screen fake_elowen
    show first with close_eyes:
        pause 1.5
        xalign 0.0 zoom 1.45 yalign 0.75
        ease 10 yalign 1.0 xalign 0.0
        subpixel True
    "В голове Кэссиди всплывали все те моменты, когда она приходила сюда, чтобы высказаться или выплакаться."
    "А также те, когда она вся замарывалась в грязи, пытаясь собирать фрукты."
    "Было и много других, по-настоящему унизительных моментов. От стыда принцесса уставила свой взгляд в землю."

    scene first meeting2 with Dissolve(1):
        xalign 0.0 yalign 0.0 zoom 1.3 subpixel True
        ease 10 xalign 0.5

    "Однако, когда она наконец подняла глаза, она увидела улыбку на лице Элоўэн."
    "Кэссиди почувствовала облегчение."

    e "Так что тебя сюда привело на этот раз?"
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c "Я хотела успокоиться."
    $ hide_alpha = 0
    hide screen fake_elowen
    show first meeting1 with dissolve
    e "Успокоиться? Отчего? Что вообще могло тебя потревожить?"
    c_t "Она так сухо говорит. Она что, думает, что я целыми днями бездельничаю и витаю в облаках?"
    c "Много чего! Да будет вам известно, что в эту самую минуту,"
    c "передо мной стоит ответственная миссия, от выполнения которой зависит моя жизнь!"
    show first meeting2 with Dissolve(1.0):
        ease 15 zoom 1.0
    e "Вот как? И при этом ты сейчас стоишь здесь и песенки поёшь? И что же это за миссия такая, позволь узнать?"
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen

    c "Хм! По-видимому, здесь не рады моему присутствию. В таком случае, я вернусь к своим поискам!"

    $ hide_alpha = 0
    hide screen fake_elowen

    "И когда Кэссиди уже собиралась развернуться и уйти, оставив позади вистерию и сидящую под ней Элоўэн,"
    "Она услышала нежный смех Элоўэн. Этот звук завораживал."

    e "Похоже, я оскорбила миледи. Уверяю, я не хотела никого обидеть."
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c "Правда?.."
    hide screen fake_elowen
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e "Истинно так, я бы ни за что не хотела причинить тебе боль. Так расскажи же, что за задача перед тобой стоит?"
    hide screen fake_cassidy
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c "...У меня дрова кончились."

    $ hide_alpha = 0
    hide screen fake_elowen

    "Услышав это, Элоўэн встала и отряхнулась."

    scene forest:
        xalign 0.0
    with Dissolve(2)

    show elowen at topleft:
        zoom 0.54
    show cassidy lowered down pout sweatdrop at topright:
        zoom 0.54
    with dissolve

    e "Позволь мне помочь тебе."
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c open unhappyopen2 raised -sweatdrop "Нет-нет, я никак не могу—"
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen




    e closed unhappyopen "{w=0.5}Прошу, это дерево так сильно страдает каждый раз, когда ты проливаешь на него свои слёзы."
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c fierce narrowed pout blush "{w=0.5}!!.."
    $ hide_alpha = 0

    hide screen fake_elowen
    with dissolve
    scene forest:
        xalign 0.6
    with area_move

    "Несмотря на грубую простоту в общении, Элоўэн трудилась не покладая рук, оказав огромную помощь."
    "Она научила Кэссиди собирать хворост и отрубать топором ветки побольше."

    show elowen at topleft:
        zoom 0.54
    show cassidy at topright:
        zoom 0.54
    with dissolve

    e "Если ты скрутишь вместе те палки, что поменьше, то они замечательно будут гореть." with dissolve
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c wide raised happyopen2 "Ясно! Ох, как же хорошо, что мне не пришлось рубить целое дерево. Я так боялась, что может дойти до этого."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e closed unhappyopen lowered "Да... Если срубить дерево, оно уже не вырастет."
    e "Можно собрать с них фрукты, срубить пару веток. Но корни и вены дерев нужно сохранять."
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    show elowen frown with dis
    c mismatched sideeye worried sweat "Вены?"
    $ hide_alpha = 0
    hide screen fake_elowen
    show cassidy glow
    show black behind cassidy:
        alpha 0.5
    with dissolve
    c_t "У деревьев есть кровь?"
    show cassidy normal
    hide black
    $ hide_alpha = 1
    e open frown neutral "Знаешь, этот лес очень старый."
    e sideeye unhappyopen "Мне бы хотелось, чтобы он оставался таким, каков он сейчас, но у людей постоянно проблемы с тем, чтобы не лезть всюду."
    show elowen frown
    show cassidy none sad
    with dis


    menu:
        choice "{w=1.0}Несоответствие безразличного выражения лица Элоўэн и её пронзительного голоса заставило биться серце Кэссиди."
        with ctransition
        "«Должно быть, она пережила что-то страшное».":
            $ chosen_text = "«Должно быть, она пережила что-то страшное»."
            show screen chosen
            pause 1
            hide screen chosen
            $ k_pts += 1
            c sad closed2 smile2 none "Мы — люди — любим лезть куда не надо, верно?"
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            e "........."
            $ hide_alpha = 0
            hide screen fake_cassidy
            show cassidy lowered down pout -sweat glow
            show black behind cassidy:
                alpha 0.5
            with dissolve
            c_t "Я думала, она поймёт, к чему я. Но, кажется, я показалась слишком легкомысленной по отношению к её чувствам."
            show cassidy open neutral happyopen normal
            hide black
            with dissolve
            c "Ты... действительно любишь этот лес."
            $ hide_alpha = 1
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            e raised narrowed smirk "Да. На самом деле, я чувствую, что я — это часть его, а он — часть меня."
            $ fake_c_text = ""
            hide screen fake_cassidy
            show cassidy glow
            show black behind cassidy:
                alpha 0.5
            with dissolve
            c_t "Как же это прекрасно..."
            $ happenings.append("2")
        "«Должно быть, она очень любит деревья».":

            $ chosen_text = "«Должно быть, она очень любит деревья»."
            show screen chosen2
            pause 1
            hide screen chosen2
            $ k_pts = 0
            c open neutral happyopen2 none "Согласна. Природа великолепна, не так ли?"
            $ hide_alpha = 1
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            e "Временами, да, она может быть таковой."
            $ hide_alpha = 0
            show cassidy sad closed2 smile2 sweatdrop glow
            show black behind cassidy:
                alpha 0.5
            with dissolve
            hide screen fake_cassidy
            c_t "...Как-то неловко вышло. Что она вообще имела в виду под этим?"

    scene forest:
        xalign 0.6
    with dissolve

    "Они продолжили идти по лесу, собирая ветки и непринуждённо разговаривая."

    scene forest evening:
        xalign 0.6
    with Dissolve(1)

    "И по мере их неторопливой прогулки, солнце начало садиться."
    "Да и рюкзачок на плечах Кэссиди уже был почти полон."

    show elowen at topleft:
        zoom 0.54
    show cassidy at topright:
        zoom 0.54
    with dissolve

    $ hide_alpha = 1

    e "Похоже, ты собрала уже довольно много веток."
    e "Полагаю, этого должно хватить?"
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c wide raised unhappyopen2 "Ах, да, ты права!"
    $ hide_alpha = 0
    hide screen fake_elowen
    show cassidy frown down lowered with dis
    "Время пролетело незаметно для принцессы."
    "И теперь, когда их совместный вечер подходил к концу, Кэссиди... боялась."
    "Боялась, и была полна надежды, что, наверное, было ещё страшнее."
    e sideeye unhappyopen "Что ж—"
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c raised wide unhappyopen2 "Простите, мисс Элоўэн!!"
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e wide raised frown "...Да?"
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c sad open smile2 blush "Могу ли я... То есть, можем ли {i}мы{/i} ещё встретиться?"
    c "Вы даже не представляете, как я счастлива, что встретила в этом лесу ещё кого-то."
    c "И... и {i}девушку{/i} особенно."
    $ hide_alpha = 0
    hide screen fake_elowen
    show elowen neutral narrowed smile1 with dis
    "В это время на лице Элоўэн проявилось наличие у неё готовой идеи на этот счёт."

    e "Я хотела спросить то же самое."
    e neutral closed unhappyopen "Большую часть вечеров я провожу на этом месте. Ищи меня здесь."
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    show elowen frown with dis
    c neutral open happyopen2 none "Понятно! Тогда... До завтра."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    show cassidy smile2 with dis
    e "В таком случае, до скорого, миледи."
    hide elowen with dis1
    $ hide_alpha = 0
    hide screen fake_cassidy
    "Сказав это, Элоўэн поклонилась и ушла."

    show cassidy at top:
        zoom 0.7
        yoffset -100
    with dissolve
    show cassidy glow neutral down smile1 blush
    show black behind cassidy:
        alpha 0.5
    with dissolve

    c_t "Её шаги почти бесшумны. Как же она грациозна."
    c_t "Не только красива, но и изящна... и умна."


    scene sky evening orange with fadeup

    "Голова Кэссиди была так сильно забита мыслями о Элоўэн,"
    "что по пути домой принцесса совершенно забыла про усталость и тяжёлый груз на плече."

    c_t "Она, конечно, очень... своенравная. Но у неё должен быть такой большой опыт самостоятельной жизни в лесу!"

    c "Надеюсь, я не стану ей обузой..."
    stop music fadeout 2
    "И с этими мыслями некогда-принцесса вернулась домой,"
    "совершенно не подозревая, что корни судьбы уже опутывают ей ноги и утягивают вниз..."

    scene sky night clear with Dissolve(2)

    jump day2

label day2:


    $ save_name = "День второй"

    play music [ "<silence 1.0>", "sound/madbox.ogg" ]

    scene sky with Dissolve(2)

    scene black with Dissolve(2)

    window hide None
    poem "\n\n\n{w=0.5}Говорят, что лишь дурак проводит свои дни" with Dissolve(0.5)
    poem "Не изменяя ничего, но ожидая перемен."
    poem "Но кто так говорит — опутаны рутиной, как по мне."
    poem "Ничем довольные, не ожидают ничего они."
    play sound "sound/thump.ogg"
    poem "\n\n{size=+15}{cps=10}День второй.{/cps}{/size}"

    nvl clear

    postnvl "{nw}"

    stop music fadeout 6
    scene sky with Dissolve(2)
    scene exteriorhouse with Dissolve(2)
    scene room with Dissolve(2)

    window auto

    stop music


    play music "sound/memory.ogg"
    "Когда человек закрывает только что дочитанную книгу, им овладевает такое меланхоличное чувство,"
    "Он ощущает, как последние слова книги стекают по нему, и он возвращается из мира книги в мир настоящий."

    "Кэссиди за свою жизнь привыкла к этому чувству."
    "В своей прошлой жизни она получала лучшее образование, какое только можно было купить, как легально, так и окольными путями."

    "Теперь же её светлый ум был вынужден томиться, довольствуясь не более чем парой новых книг в месяц."
    "И к этому времени Кэссиди уже взяла в привычку читать очень медленно, чтобы растягивать удовольствие."

    "Она закрыла последний том и положила его на стол рядом с недописанным письмом своему брату."

    show cassidy mismatched down frown at top:
        zoom 0.7
        yoffset -100
    with dissolve

    c "В письмах я всегда звучу не так, как в жизни."
    c sideeye "Как правильно написать человеку, которого ты прежде видела каждый день?"
    c "И как вообще что-либо написать, когда твоя жизнь стала столь... столь {i}скучной{/i}?"
    show cassidy down neutral with dis
    "Принцесса всё же решила написать ещё пару предложений о том, как {i}тронула её{/i} прочтённая книга, и как сильно она расстроена тем, как эта книга закончилась."
    show cassidy sad smile1 glow
    show black behind cassidy:
        alpha 0.5
    with dissolve
    c_t "Семья важна, но столь же важно осознавать, насколько ценно то, что у тебя сейчас есть, — иначе может стать слишком поздно."
    c_t "Если бы только король понимал, какая замечательная была у него дочь."
    c_t "И... и надеюсь, что ты понимаешь, как сильно твоя единственная сестра любит тебя."
    show cassidy wide raised unhappyopen normal
    hide black
    with dis
    "Переполняемая чувствами, принцесса остановилась, и решила последнюю часть удержать при себе."
    show cassidy sad down frown with dis
    "Эти строки были слишком откровенными и плаксивыми, выпрашивающими утешения. {i}Принцессам{/i} не подобает писать такое."
    c "Нет, так не пойдёт. Так нельзя. Определённо..."
    show cassidy sideeye unhappyopen lowered with dis
    "Кэссиди глубоко вздохнула и посмотрела на огонь в печи. Теперь у неё было предостаточно дров, чтобы продержаться до следующего привоза."
    "И эта мысль напомнила ей об Элоўэн."

    stop music fadeout 2

    c neutral open smile1 "Интересно, что сейчас делает Элоўэн?"

    hide cassidy with dis1

    "Принцессе едва ли под силу было представить, какова обыденная жизнь у столь загадочного персонажа."

    "Любопытство так поглотило её, что уже невозможно было противиться."

    "И наконец, Кэссиди решилась пойти прогуляться, чтоб по дороге найти ту даму."

    scene exteriorhouse with area_move

    show cassidy smile2 at top:
        zoom 0.7
        yoffset -100
    with dissolve

    c "Может, сегодня я даже наткнусь на её дом! Разве не было бы замечательно — сразу настигнуть её дома?"

    hide cassidy with dis1

    "И принцесса немедленно отправилась в путь, без единой мысли о том, как она может с этим спешить и какое неудобство может доставить своим визитом."

    scene forest:
        xalign 1.0
    with area_move

    play music "sound/wind.ogg"

    "Выйдя на улицу, Кэссиди глубоко вдохнула свежий лесной воздух."

    show cassidy smile1 at top:
        zoom 0.7
        yoffset -100
    with dissolve

    c happyopen2 "Какая чудесная погода! И в небе почти ни облачка."

    show cassidy sideeye catface with dis

    "Она осторожно шла всё глубже в лес, постоянно осматривая местность вокруг себя, в поисках потаённого жилища."

    show cassidy glow
    show black behind cassidy:
        alpha 0.5
    with dissolve
    c_t "Может, Элоўэн живёт в доме, схожем с моим? Она так элегантна... Не могу себе представить её за уборкой!"
    c_t sad closed2 smile1 sweat "Впрочем, ещё совсем недавно я и себя-то за уборкой не могла представить. Ох, как же время меняет человека!"

    scene forest:
        xalign 0.0
    with area_move

    "Спустя недолгое время, Кэссиди добралась до своей любимой вистерии и жадно упивалась ее видом."
    "Она подбежала к дереву и обхватила его руками, будто бы обнимая его."

    show cassidy smile1 at top:
        zoom 0.54
    with dissolve

    c happyopen2 "Здравствуй, дорогая вистерия! Ты сегодня так же прекрасна, как и всегда! Пусть никто мне нужный и не сидит под твоими ветвями."
    show cassidy sideeye catface with dissolve
    show cassidy:
        easeout 0.5 xoffset -150
        pause 0.1
        easein 0.5 xoffset 0
        easeout 0.5 xoffset 150
        pause 0.1
        easein 0.5 xoffset 0
    with None
    "Принцесса посмотрела сначала в одну сторону от дерева, потом в другую, всматриваясь в лесную чащу в попытках разглядеть окошко или дым от печи."
    "Но к сожалению, видела она только сплошные деревья."
    c unhappyopen raised sweatdrop "Не может же Элоўэн жить в домике на дереве?"

    e "Конечно же нет."

    show elowen at topleft:
        zoom 0.54
    with moveinbottom


    show cassidy wide raised unhappyopen2 -sweatdrop with dissolve
    show cassidy:
        easein 0.1 yoffset -70
        easein 0.2 yoffset 0
    with None



    c "Ай—!!"

    "Кэссиди подскочила от испуга, но её нога в этот момент зацепилась за торчащие корни дерева, и принцесса полетела вперёд."

    show elowen raised wide worried with dissolve
    show elowen:
        easeout 0.5 xoffset 135
    with None

    e "Осторожно!"
    "Элоўэн в тот же миг вытянула руку и успела вовремя схватить принцессу."
    show elowen neutral sideeye frown
    show cassidy blush
    with dis
    "Её рука была холодной как лёд, но движения уверенными, а хватка — крепкой, словно тиски. Сердце Кэссиди заколотилось."
    show cassidy sad open happyopen glow
    show black behind cassidy:
        alpha 0.5
    show elowen behind black
    with dissolve
    c_t "Она так сильно беспокоится за меня?"
    show cassidy normal -blush smile1 neutral at topright:
        yoffset 0
    hide black
    show elowen at topleft:
        xoffset 0
    with Dissolve(1)
    "Кэссиди понадобилось некоторое время, чтобы придти в себя."
    "Элоўэн тоже выглядела немного потрясённой."
    c "Слава богу, ты появилась так вовремя!"
    c "Хотя, сказать по правде, я бы не упала, если бы ты меня не напугала."
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e closed lowered "Неужели? В таком случае буду стараться впредь быть не такой страшной."
    $ hide_alpha = 0
    hide screen fake_cassidy
    show cassidy glow down sweatdrop lowered pout
    show black behind cassidy:
        alpha 0.5
    with dissolve
    menu:
        c_t_choice "О боже, она, наверное, не так меня поняла... Я ведь только хотела этим прикрыть свою неловкость."
        with ctransition
        "Может, Элоўэн так пошутила.":
            $ chosen_text = "Может, Элоўэн так пошутила."
            show screen chosen
            pause 1
            hide screen chosen
            $ u_pts += 1
            c_t open mismatched "С другой стороны... Может, это была шутка?"
            show cassidy neutral smile2 normal none
            hide black
            with dissolve
            c "Хе-хе."
            $ hide_alpha = 1
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            e open smile1 neutral "...Улыбка тебе идёт гораздо больше."
            $ fake_e_text = _last_say_what
            show screen fake_elowen
            hide screen fake_cassidy
            c blush "Как и тебе."
            $ happenings.append("3")
        "«Не нужно так говорить, всё хорошо».":

            $ chosen_text = "«Не нужно так говорить, всё хорошо»."
            show screen chosen2
            pause 1
            hide screen chosen2
            show cassidy normal unhappyopen none open neutral
            hide black
            with dissolve
            c "Я не совсем поняла, о чём ты. Я вовсе не считаю тебя страшной."
            $ hide_alpha = 1
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            e "Вот как? А по твоим прошлым высказываниям мне так не кажется."
            $ fake_e_text = _last_say_what
            show screen fake_elowen
            hide screen fake_cassidy
            c down lowered frown "Я всего лишь... Ох, неважно."
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            hide screen fake_elowen
            e narrowed unhappyopen "Ты странная."
            show elowen frown with dis
            $ fake_e_text = _last_say_what
            show screen fake_elowen
            hide screen fake_cassidy

    c neutral open happyopen none "И всё же, как же необычно, что мы снова встретились!"
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e sideeye smirk raised "Ты сюда часто приходишь. А я живу рядом. Что в этом такого необычного?"
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c "Я имела в виду, что это такая счастливая случайность! Должно быть, это судьба!"
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e "Уверяю тебя, судьба тут ни при чём."
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c happyopen2 blush "Возможно, но ведь гораздо романтичнее думать, что нас свела судьба!"
    show cassidy smile1 with dis
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e frown down lowered "Не могу представить себе ничего {i}менее{/i} романтичного, чем судьба."
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c none worried narrowed mismatched "{size=+10}?{/size}"
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e sideeye unhappyopen raised "Может, тебе пока ещё этого просто не понять."
    show elowen frown with dis
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c pout sweatdrop fierce "Не говори со мной так, будто ты намного старше и мудрее меня!"
    show elowen neutral smile1 neutral with dissolve
    $ hide_alpha = 0
    hide screen fake_elowen
    hide screen fake_cassidy

    "Элоўэн усмехнулась."
    c none raised sideeye unhappyopen "Кстати говоря, сколько тебе лет?"
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    show elowen unhappyopen
    show cassidy pout
    with dis
    e "А как ты думаешь?"
    show elowen smile1
    show cassidy narrowed lowered
    with dis
    $ hide_alpha = 0
    hide screen fake_cassidy
    "Кэссиди уставилась на Элоўэн, всматриваясь глубоко в её глаза, будто бы в них сокрыт ответ."
    c closed2 neutral catface blushforclosed2 "...Возможно, больше, чем мне сперва показалось."
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e closed smirk lowered "Хороший ответ."

    $ hide_alpha = 0
    hide screen fake_cassidy

    hide elowen
    hide cassidy
    with dis1

    "Элоўэн качнула головой, как бы предлагая пойти прогуляться. Кэссиди же была только рада этому."
    "И вместе они отправились на прогулку."

    scene forest:
        xalign 0.5
    with area_move

    "Они обе не говорили ни слова."
    "Кэссиди, никогда не отличавшаяся молчаливостью, очень хотела нарушить тишину, но она не знала, какой разговор мог бы заинтересовать Элоўэн."

    "Принцесса украдкой всматривалась в профиль Элоўэн — он казался ей таким благородным и выразительным."

    show elowen at topleft:
        zoom 0.54
    show cassidy sideeye blush at topright:
        zoom 0.54
    with dissolve

    show cassidy glow
    show black behind cassidy:
        alpha 0.6
    with dissolve

    c_t "У неё аристократическая внешность. Почему же она живёт в лесу?"
    c_t none down sad pout "Хотя, опять же, разве нельзя того же сказать обо мне?.."
    c_t "Может, ей тяжело об этом говорить."

    hide black
    show cassidy normal closed1 worried
    with dissolve

    "По поляне пронёсся ледяной порыв ветра, от которого Кэссиди вздрогнула и потёрла свои неприкрытые руки."

    e sideeye unhappyopen raised "Солнце скоро уже сядет, и будет становиться только холоднее. Возможно, тебе стоит—"

    "И в этот момент, наконец, в голове принцессы возник вопрос, над которым она размышляла весь вечер."

    c wide raised unhappyopen2 blush "Не хочешь зайти ко мне в гости?!"
    show cassidy worried
    show elowen raised wide unhappyopen
    with dis
    "Элоўэн немного растерялась."
    e "Будет ли это... умно?"
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    show elowen frown with dis
    c none down lowered pout "Что ты имеешь в виду?"
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e lowered sideeye worried "Ты приглашаешь к себе домой человека, которого едва знаешь. Не слишком ли много доверия?"
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c raised open happyopen2 "Ну как же! Двум одиноким дамам определённо лучше быть вместе здесь, в диком лесу. И потом, кого ещё мне приглашать?"
    c sad narrowed smile2 "Я... Понимаешь, иногда я чувствую себя здесь очень одиноко. У тебя такого не бывает?"

    $ hide_alpha = 0
    hide screen fake_elowen

    show elowen lowered dilated worried with dis

    "Элоўэн немного повернула голову и всмотрелась в лес за их спиной, будто бы смотря на что-то, что лишь она способна узреть."

    e lowered closed unhappyopen "Одиночество, значит... Понятно."
    e neutral open "Хорошо, я приму твоё предложение."
    show elowen frown
    show cassidy neutral closed2 smile1 blushforclosed2
    with dis
    "Пускай и озадаченная тем, как Элоўэн колебалась с ответом, Кэссиди была в восторге от того, что та всё же согласилась, и, припрыгивая от радости, привела Элоўэн к себе домой."

    scene exteriorhouse evening with area_move

    play music "sound/moon.ogg" fadeout 2

    "И лишь на пороге своего дома Кэссиди внезапно осознала, насколько необдумано было её предложение."

    c_t "А у меня вообще прибрано в доме?.."
    "Она совсем не могла вспомнить, когда в последний раз подметала или проветривала постель."

    show elowen at topleft:
        zoom 0.54
    with dissolve

    e "Ты здесь живёшь?"

    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen

    show cassidy sad down smile1 sweatdrop at topright:
        zoom 0.54
    with dissolve
    c "...Да."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e "Очаровательно."
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c narrowed smile2 none "Спасибо! Хотелось бы, чтобы мой вклад в его красоту был всё же побольше."
    c "Этот дом стоял здесь задолго до моего приезда. Даже мебель не моя."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e closed "И тем не менее... Он тебе подходит."
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c neutral open smile1 "...Спасибо."

    $ hide_text = 0
    hide screen fake_elowen

    hide cassidy
    hide elowen
    with dis1

    "Ободрённая ответом, Кэссиди отмела сомнения и, широко распахнув входную дверь, уверенным жестом пригласила Элоўэн войти."

    if k_pts >= 1:

        "И когда та неестественно медленно и осторожно входила в дом, Кэссиди не могла не обратить внимания на её стопы."

        show feet with Dissolve(1)
        $ happenings.append("2b")

        c_t "...Её пальцы подогнуты. Как странно."
        "Даже когда Элоўэн ступала, её пальцы оставались согнутыми."
        c_t "Может, она не для красоты так ходит. Может, она вынуждена так делать."
        "Может, у Элоўэн болят ноги? Кэссиди подумала, и решила, что спросит об этом, когда подвернётся подходящий случай."

    scene room evening with area_move

    show elowen sideeye at topleft:
        zoom 0.54
    with dissolve

    e "Тут весьма просторно. Ты тут... одна живёшь?"
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    show cassidy at topright:
        zoom 0.54
    with dissolve
    c "Именно так."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e lowered "........."
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c sweatdrop sad down smile2 "Не так уж это и плохо! Никто не говорит мне, что делать, куда идти... Я сейчас свободна, как никогда."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e lowered closed unhappyopen "Возможно. Но я думаю, что иногда проще, когда ты привязана к чему-то."
    e dilated "Когда ты не понимаешь, что тебя душат, это кажется довольно приятным и кружащим голову действом."
    show elowen worried with dis
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c none narrowed mismatched unhappyopen "Ам-м?.. Я не совсем понимаю..."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e sideeye smirk neutral "Ничего, это нормально, если не ты понимаешь."

    $ hide_alpha = 0
    hide screen fake_cassidy

    hide cassidy
    hide elowen
    with dis1

    "Элоўэн медленно прошла из одной части комнаты в другую, проводя самыми кончиками пальцев по всему вокруг."
    "Она будто бы впитывала энергию каждого предмета, считывая его историю и добираясь до его истинной сути."
    "Кэссиди стало интересно, что бы Элоўэн смогла узнать о {i}ней самой{/i}, если бы принцесса ей позволила. Если бы только осмелилась позволить."

    "В комнате стояла невыносимая тишина."
    "Как вдруг Элоўэн наткнулась на книгу, которую Кэссиди дочитала этим утром."
    show elowen at topleft:
        zoom 0.54
    show cassidy at topright:
        zoom 0.54
    with dissolve
    c raised happyopen2 "О, эту книгу мне прислал мой брат!"
    c sad smile2 "Мне здесь бывает просто смертельно скучно, а в этих книгах я нахожу своё пристанище. И скоро должна приехать очередная посылка."
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e raised "У тебя есть брат?.."
    $ hide_alpha = 0
    hide screen fake_cassidy
    show elowen dilated lipbite with dis
    "Элоўэн молчала некоторое время, переваривая эту информацию."
    stop music fadeout 2
    show elowen demonic frown with dis
    "После чего её взгляд упал на недописанное письмо, неаккуратно лежащее рядом с книгой."
    show cassidy raised wide unhappyopen2
    show elowen narrowed lowered
    with dissolve
    show cassidy:
        easeout 0.1 yoffset -70
        easein 0.3 yoffset 0
    with None
    "Кэссиди последила за её взглядом. Её глаза округлились, и она резко выскочила вперёд и схватила письмо."
    show cassidy down sad pout with dis
    "Как много она успела прочесть?"
    show cassidy blush with dis
    "Принцесса покраснела от стыда."

    play music "sound/troubleinparadise.ogg" fadein 2

    e "Твой брат далеко отсюда."
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c none frown "...Да."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e sideeye "А то место, где вы жили вместе, — оно красивое?"
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c closed1 "Я ни разу не видела места, подобного ему."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e fierce narrowed unhappyopen "Красивее, чем эта тюрьма, в которой ты сейчас живёшь?.."

    $ hide_alpha = 0
    hide screen fake_cassidy

    show cassidy raised wide tears1 unhappyopen
    show elowen frown
    with dis1

    menu:
        choice "Кэссиди не могла сдержать удивления, вызванного столь едкими словами Элоўэн... как не могла сдержать и внезапно накативших слёз."
        with ctransition
        "«Прости, {i}что{/i}?»":
            $ chosen_text = "«Прости, {i}что{/i}?»"
            show screen chosen
            pause 1
            hide screen chosen
            $ d_pts += 1
            c tears2 fierce narrowed "Мне не нравится твой тон."
            $ hide_alpha = 1
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            e raised thinpupil smirk "И всё же я не вижу, чтобы ты была не согласна со мной."
            $ fake_e_text = _last_say_what
            show screen fake_elowen
            hide screen fake_cassidy
            c angry tears2 narrowed2 unhappyopen "Я очень даже {i}не согласна{/i}! Ты не представляешь, как сильно мой брат заботится обо мне."
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            hide screen fake_elowen
            e fierce smile1 "Что ж, в одном ты точно права."
            $ hide_alpha = 0
            hide screen fake_cassidy
            show cassidy down none frown fierce with dis
            "Кэссиди нервно вытерла слёзы."
            $ happenings.append("4")
        "«Ты не так всё поняла».":

            $ chosen_text = "«Ты не так всё поняла»."
            show screen chosen2
            pause 1
            hide screen chosen2
            $ d_pts = 0
            "Принцесса аккуратно, но уверенно протёрла глаза. Это было неподходящее время для слёз."
            c none sad down frown "Всё... довольно сложно. Не так очевидно, как тебе кажется."
            $ hide_alpha = 1
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            e sideeye neutral unhappyopen "Все всякого сомнения. Людские деяния часто таковы."
            e dilated "Но всё, что мне важно знать, так это то, что он — там, а ты — здесь."
            e "И несложно догадаться, что это именно он в ответе за то, что вы сейчас не вместе."
            show elowen frown with dis
            $ fake_e_text = _last_say_what
            show screen fake_elowen
            hide screen fake_cassidy
            c narrowed smile2 "А ты, похоже, очень быстро читаешь, раз так скоро смогла придти к такому выводу."
            c "Я... я не несчастлива здесь, Элоўэн."
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            hide screen fake_elowen
            e raised "И ты можешь прям честно об этом заявить? От чистого сердца?"
            $ hide_alpha = 0
            hide screen fake_cassidy
            show room night with dis1
            "Элоўэн посмотрела в глаза Кэссиди, и их взгляды сплелись, словно магниты, притягивая друг друга всё ближе, и ближе..."
            show cassidy closed1 frown
            show elowen sideeye worried lowered
            with dis
            "Но Кэссиди не смогла ничего произнести. Глядя глубоко в глаза Элоўэн, она не могла сказать неправду."

    show elowen neutral open frown with dis
    "Элоўэн посмотрела в окно."
    e "...Уже стемнело."
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c sad wide pout none "О боже! Где мои манеры, я же не предложила тебе чай или ещё чего-нибудь..."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e "Не волнуйся обо мне."
    e sideeye unhappyopen "Мне нужно идти. Я не хотела стеснять тебя так долго своим присутствием."
    show elowen frown with dis
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c sad open smile1 sweatdrop "Ты нисколько не стесняешь меня."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e lowered closed unhappyopen "Ты такая добрая. Хорошая."
    $ hide_alpha = 0
    hide screen fake_cassidy
    show elowen worried
    show cassidy neutral blush happyopen2
    with dis
    "Лицо Кэссиди засияло."
    e lowered narrowed unhappyopen "В таком мире, как наш, доброта долго не живёт."
    show elowen sad frown
    show cassidy sad narrowed pout none
    with dis
    "На этих словах лицо Кэссиди тут же и потухло."
    hide elowen with Dissolve(1)
    "Поклонившись, Элоўэн вышла за дверь и испарилась, оставив после себя боль и смятение."
    stop music fadeout 2
    if d_pts >= 1:
        c_t down tears1 worried "Я должна верить, что Александр любит меня. В противном случае, что со мной станет?.."

    scene sky night cloudy with fadeup
    "Когда принцесса повернулась к окну, чтобы посмотреть на вид, на который перед этим смотрела Элоўэн, она увидела перед собой лишь мрак неопределённости."

    play music "sound/madbox.ogg"

    scene black with Dissolve(2)

    jump day3

label day3:

    $ save_name = "День третий"

    window hide None

    poem "\n\n\n{w=0.5}Без жизненного опыта и мудрости" with Dissolve(0.5)
    poem "Вокруг лишь ураганы будут выть."
    poem "Но коли, дорогая, ты поблизости,"
    poem "Ураган меня не сможет истощить."
    play sound "sound/thump.ogg"
    poem "\n\n{size=+15}{cps=10}День третий.{/cps}{/size}"

    nvl clear

    postnvl "{nw}"

    stop music fadeout 6
    scene sky with Dissolve(2)
    scene exteriorhouse with Dissolve(2)
    scene room with Dissolve(2)

    window auto

    play music "sound/memory.ogg"

    $ letter_text = "Дорогой мой Александр,"
    show screen letter

    "Изгнанная принцесса остановилась на первой же строчке письма."
    c_t "Не слишком ли это фамильярно? Понравится ли ему такое начало?"
    hide screen letter
    "Брат, которого она помнила, был добрым мальчиком, но довольно строгим, и уделяющим особое внимание манерам."

    menu:
        choice "После событий прошлого вечера, Кэссиди чувствовала, что она вынуждена переписать незаконченное письмо."
        with ctransition
        "«Вряд ли Александр уделит этому большое внимание».":
            $ chosen_text = "Вряд ли Александр уделит этому большое внимание."
            show screen chosen
            pause 1
            hide screen chosen
            c_t "В любом случае, Александр не уделит этому много внимания. Уверена, он слишком занят, чтобы вообще дочитывать мои письма."
            c_t "И всё же... Я хочу, чтобы он знал, как протекают мои дни. Мне становится легче, когда я читаю его письма, и если мои письма так же помогают ему, то стоит стараться над их написанием."
        "«Я хочу предстать перед Александром во всей красе».":

            $ chosen_text = "«Я хочу предстать перед Александром во всей красе»."
            show screen chosen2
            pause 1
            hide screen chosen2
            $ d_pts += 1
            c_t "Я не хочу разочаровать его или наскучить деталями. Тот черновик..."
            "Она вздохнула, вспоминая содержимое уже порванных страниц."
            c_t "Я слишком жалобно звучала. Конечно, я там не откровенно ныла, но приближалась к этому."
            c_t "Я всего лишь..."
            "Она боялась признаться, даже себе, как сильно она тосковала по брату."
            $ happenings.append("5")

    if d_pts <= 0:
        $ letter_text = "Дорогой мой Александр,\n\n        Я надеюсь, что ты прочтёшь данное письмо в добром здравии. Моя жизнь здесь не меняется. Каждое утро я просыпаюсь и делаю себе завтрак с чашечкой чая. Мне очень понравился чай, который ты мне в последний раз выслал.\n        После завтрака я читаю, либо вышиваю. Наверное, ты не удивишься, когда узнаешь, что мои навыки владения иглой не особо улучшились.\n        В послеобеденное время я люблю гулять. Не волнуйся, я не ухожу далеко от дома. Мне нравится сам процесс. Меня успокаивает окружение лесных дерев.\n        В последнее время, я часто прихожу к одной вистерии. Она так красива... эта вистерия. Не помню, чтобы я видела столь прекрасные деревья в Веромире..."
        $ happenings.append("6")
        show screen letter
        with dissolve
        "Но даже после того, как она переписала своё письмо, Кэссиди не была уверена в том, насколько хорошо его содержание."
        c_t "Достаточно ли это всё интересно?"
        "Она не хотела много писать об Элоўэн, чтобы не смущать его разговорами о женщине, которую он никогда не встречал."
        "И, перепрочтя своё письмо, она поняла, что вообще ни разу не упомянула Элоўэн в нём."
        c_t "Думаю, так будет даже лучше."

    elif d_pts == 1:
        $ letter_text = "Дорогой мой Александр,\n\n        Я надеюсь, что ты прочтёшь данное письмо в добром здравии. Мне очень понравилась книга, которую ты мне в последний раз отправил.\n        Однако, у истории в ней такая грустная концовка! Хоть отец и любил всем сердцем свою младшую дочь, в итоге ни к чему хорошему это не привело. Оба умерли. Разве может быть судьба печальнее, чем умереть от руки любимого человека? Осмелюсь сказать, что нет.\n        Эта книга дала мне много пищи для размышлений, однако я всё же надеюсь, что в следующий раз ты пришлёшь мне более радостную историю. Я начинаю уставать от столь мрачных книг.\n        Жизнь моя здесь не так печальна. Благодаря твоей доброте, мне здесь хорошо. Недавно у меня были проблемы из-за того, что закончились дрова, но один человек, бродивший тогда по лесу, помог мне, так что всё закончилось хорошо..."
        show screen letter
        "Кэссиди дописала письмо без лишнего ажиотажа. Она упомянула Элоўэн просто как бродягу, помогшего с хворостом."
        "Большая же часть текста была про книгу, которую она недавно дочитала."
        c_t "Наверное, после этого он захочет прислать побольше книг."
    else:

        $ letter_text = "Дорогой мой Александр,\n\n        Я надеюсь, что ты прочтёшь данное письмо в добром здравии. Я с большим волнением ждала твоего письма. Мои дни здесь крайне скучны. Я ем, сплю, читаю книги... Единственным, что скрасило моё пребывание здесь, было знакомство с молодой дамой, живущей неподалёку.\n        Я прекрасно помню твои настоятельные просьбы держать моё пребывание здесь в секрете. Я ни разу не ходила в соседние города. А женщина эта, похоже, живёт одна в лесу, как и я. И мы не так близки, просто познакомились. Уверена, ты не будешь запрещать мне общаться с людьми вообще.\n        Ты всегда в моём сердце. По тебе одному я тоскую и плачу. Я так хочу быть снова дома, с тобой..."
        show screen letter
        "Кэссиди старательно писала своё письмо, со всем почтением к своему брату."
        "Ни на секунду она не могла забыть, как она обязана ему за имеющиеся у неё сейчас удобства."
        c_t "Пожалуйста, никогда не забывай о своей сестре, которая любит тебя так сильно."
        c_t "Готово!"
        $ happenings.append("7")


    stop music fadeout 2
    hide screen letter
    scene room evening
    with dissolve

    "Когда Кэссиди посмотрела в окно, она увидела, что солнце уже садится."

    show cassidy at top:
        zoom 0.7
        yoffset -100
    with dissolve

    c raised sideeye pout "О боже, неужели я так долго размышляла над письмом?"
    c sad closed2 sweatdrop smile1 "Какая же я глупая!"

    show cassidy neutral down smile1 none with dis

    "Она сложила письмо, положила его в конверт, и поставила королевскую печать, которую ей дали при дворе."

    if d_pts == 2:
        show cassidy closed2 with dis
        "Затем она поцеловала конверт и подписала, что он для Александра."

    show cassidy closed1 fierce smile1 with dis
    "Она встала и вытянула руки над головой."

    play music "sound/silk.ogg"

    c raised sideeye unhappyopen "Я весь день почти не двигалась! Это не хорошо."

    scene exteriorhouse evening with area_move

    "Кэссиди подошла ко входу и подложила письмо под дверь, откуда обычно посыльные её брата забирали письма."
    "Она только подоткнула письмо под дверь, как вдруг..."
    e "Принцесса?"
    "Кэссиди на секунду оцепенела."
    "Но вскоре поняла, кто её окликнул, и успокоилась."

    show elowen at top:
        zoom 0.7
        yoffset -100
    with dissolve

    c "Элоўэн, не ожидала тебя увидеть!"
    "Сказала она через полуоткрытое окно в прихожей."
    c "Ты же знаешь, никакая я не принцесса."
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e closed lowered "Неужели? А по мне так ты выглядишь очень даже как принцесса."
    $ hide_alpha = 0
    hide screen fake_cassidy
    "Кэссиди не знала, как лучше ответить на этот комплимент."
    c_t "Я, наверное, не говорила ей, что я {i}была{/i} принцессой? Как-то я не думала о том, что всё ещё веду себя подобным принцессе образом."
    c_t "То, к чему ты привыкала всю жизнь, видимо, не может так быстро из тебя выветриться."
    e raised open unhappyopen "Там, кстати, конверт под дверью."
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    show elowen frown with dis
    c "А, да. Оставь его там. Его заберут."
    hide screen fake_elowen
    $ fake_c_text = _last_say_what
    show screen fake_cassidy


    e narrowed worried "...Заберут?.."
    $ hide_alpha = 0
    hide screen fake_cassidy
    show elowen closed with dis
    "Элоўэн заметно призадумалась, и решила не продолжать данную тему."
    e "Я могу войти?"
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c "Конечно! Прости, я уже давно должна была тебе сама предложить войти. Я просто всё ещё прихожу в себя."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e open unhappyopen "Я не хотела тебя так испугать."
    hide screen fake_cassidy
    show elowen frown with dis
    $ fake_e_text = _last_say_what
    show screen fake_elowen

    c "Всё хорошо! Это приятный сюрприз. Я очень рада тебя видеть."
    $ hide_alpha = 0
    hide screen fake_elowen
    "Она открыла дверь и проводила Элоўэн в дом."

    scene room evening with area_move

    "После этого Кэссиди уже не забывала о манерах."
    scene kitchen evening with area_move
    "Она быстро помчалась на кухню, чтобы налить гостю чай, и взяла печенье, которое берегла специально для подобного случая."
    scene room evening with area_move

    show elowen at topleft:
        zoom 0.54
    with dissolve

    show cassidy at topright:
        zoom 0.54
    with dissolve

    "Элоўэн учтиво попивала чай, но не трогала печенье."

    show black behind cassidy:
        alpha 0.5
    show cassidy glow mismatched sideeye worried
    with dissolve

    menu:
        c_t_choice "Хм-м?.."
        with ctransition
        "«Я полагаю, она уже ела недавно».":

            $ chosen_text = "«Я полагаю, она уже ела недавно»."
            show screen chosen
            pause 1
            hide screen chosen
            $ k_pts += 1

            c_t neutral open catface "Лицо Элоўэн сияет здоровьем. Полагаю, она недавно уже поела. Мне она кажется человеком, который следит за своей фигурой!"
            c_t closed2 "И уже довольно поздно... Да, уверена, она уже ужинала и больше есть сегодня не будет."
            hide black
            show cassidy normal
            with dissolve
            "Кэссиди решила не принимать это близко к сердцу, и налегла на печенье сама."
        "«Интересно, почему она не ест?»":

            $ chosen_text = "«Интересно, почему она не ест?»"
            show screen chosen2
            pause 1
            hide screen chosen2
            c_t "Интересно, почему она не ест? Может, это печенье не в её вкусе."
            c_t lowered down pout "Похоже, мне незачем уже беречь эти печенья до следующего раза, когда она придёт."
            hide black
            show cassidy normal
            with dissolve
            "Немного озадаченная, Кэссиди съела пару печений перед тем, как убрать их в шкаф."
            $ happenings.append("8")

    show cassidy neutral open smile2
    show elowen sideeye worried
    with dis
    "По мере того, как девушки какое-то время обменивались любезностями, стало ясно, что внимание Элоўэн сконцентрировано на чём-то другом."

    $ hide_alpha = 1
    c raised unhappyopen "Всё в порядке?"
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e narrowed raised "А почему ты спрашиваешь?"
    $ fake_e_text = _last_say_what
    hide screen fake_cassidy
    show screen fake_elowen
    c lowered down pout "Ты выглядишь какой-то напряжённой."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e "........."
    $ fake_e_text = _last_say_what
    hide screen fake_cassidy
    show screen fake_elowen
    c closed2 sad catface sweatdrop "Сильнее, чем обычно."
    $ fake_c_text = _last_say_what
    hide screen fake_elowen
    show screen fake_cassidy
    e sideeye lipbite "........."

    stop music fadeout 2

    e down worried "То письмо..."
    $ fake_e_text = _last_say_what
    hide screen fake_cassidy
    show screen fake_elowen
    c none neutral "М-м?"
    $ fake_c_text = _last_say_what
    hide screen fake_elowen
    show screen fake_cassidy
    e fierce "Ты сказала, что его заберут. Это письмо, которое ты написала своему брату?"
    $ fake_e_text = _last_say_what
    hide screen fake_cassidy
    show screen fake_elowen
    c happyopen2 open "А, да. Когда я оставляю письма под дверью, их потом кто-нибудь забирает."
    $ fake_c_text = _last_say_what
    hide screen fake_elowen
    show screen fake_cassidy
    show cassidy smile2
    show elowen lowered narrowed
    with dis
    e "Кто-нибудь? Это как? Ты не ходишь в город на почту?"
    $ hide_alpha = 0
    hide screen fake_cassidy
    show cassidy mismatched sideeye pout with dis
    "Кэссиди не знала, как это лучше объяснить. Она понимала всю необычность своей ситуации."
    $ hide_alpha = 1
    c neutral happyopen open "Понимаешь, хоть я и живу тут одна, обо мне хорошо заботятся. Мой брат меня всем обеспечивает."
    c "Примерно раз в две недели его люди привозят мне еду и припасы."
    c "И ещё кто-то прибегает пару раз в день, чтобы забрать мою почту."
    c sad smile1 "Конечно же, иначе как письмами, я с ним общаться не могу."

    play music "sound/darkfate.ogg"

    $ fake_c_text = _last_say_what

    show screen fake_cassidy

    e demonic lowered unhappyopen "...Похоже, я не ошиблась, когда сравнила это место с тюрьмой."
    e "Тогда почему ты живёшь здесь, одна, если у него есть средства, чтоб тебя всем обеспечить?"
    $ hide_alpha = 0
    hide screen fake_cassidy
    show elowen frown with dis
    "Кэссиди нервно заёрзала на стуле."
    show cassidy down sad pout with dis
    "Глаза Элоўэн не столько смотрели на принцессу, сколько прямо ей в душу."
    "Кэссиди чувствовала осуждение, чувствовала себя недостойной, даже ещё не ответив на вопрос Элоўэн."
    "Как бы она ни сформулировала ответ у себя в голове, он всегда звучал ужасно."

    show cassidy unhappyopen with dis

    if u_pts >= d_pts:
        c "Я здесь из соображений собственной безопасности."
    else:

        c "Мой брат меня сюда отправил, чтобы огородить меня."
        $ happenings.append("9")

    c "Я..."
    show cassidy lipbite with dis
    "Кэссиди глубоко вздохнула."

    c lowered open unhappyopen "Когда ты ранее назвала меня «принцессой», ты не так уж сильно ошиблась. Я когда-то действительно была принцессой, но уже не являюсь ею."
    show elowen neutral narrowed worried with dis
    c sideeye "Когда мой отец — король — умер, я должна была наследовать престол, но наши парламентарии меня не поддержали."
    c down worried "Хуже того, на меня сфабриковали дело об... измене. Меня могли в любое время казнить."
    c sad narrowed smile1 "Но мой брат вмешался, поручился за меня."
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e sad down "И ты..."
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c narrowed2 mismatched smile2 "{i}Жива{/i}. В изгнании, но жива."
    $ hide_alpha = 0
    hide screen fake_elowen
    "Бывшая принцесса была удивлена глубиной собственных чувств — тем, как отчаянно она пыталась убедить в том, что всё это было к лучшему. Особенно, убедить в этом саму себя."
    show cassidy lowered with dis
    e "........."
    $ hide_alpha = 1
    if d_pts >= 1:

        c closed2 "Всё не так ужасно! Тут уютный домик. И очень приятно жить в окружении природы."

        $ fake_c_text = _last_say_what
        show screen fake_cassidy

    e "Как ты умудряешься так оптимистично на всё это смотреть?"
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c raised open unhappyopen sweatdrop "Что?"
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e fierce demonic unhappyopen "Ты так хорошо отзываешься о своём брате, который сам же сослал тебя сюда, оставил тебя здесь гнить в одиночестве."
    show elowen worried with dis
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c none fierce "Всё не так, Элоўэн!"
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e narrowed2 "И что же из того, что я сейчас сказала, неправда? Скажи мне, я жду."
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c sad down pout "Я... Всё не так просто! Александр в этом не виноват."
    if not "4" in happenings:
        $ hide_alpha = 0
        hide screen fake_elowen
        "Кэссиди заметила, что она на автомате повторяет свои мысли по этому поводу, хотя сама в них верит лишь наполовину."
        "Она уже всё это говорила. И похоже, что уже не особо-то верила в это."
        $ hide_alpha = 1
    else:
        $ fake_c_text = _last_say_what
        show screen fake_cassidy
        hide screen fake_elowen
    e thinpupil unhappyopen "Твой {i}дорогой Александр{/i} вступился за тебя, и теперь ты в изгнании, не так ли?"
    e sideeye frown "Откуда ты знаешь, что это не он изначально подговорил всех голосовать против тебя?"
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c closed1 "Зачем ему это делать? Что бы он получил взамен?"
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e down worried lowered "........."
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy

    if u_pts == 0:
        c fierce narrowed2 frown "Очевидно, что ты ничего не смыслишь в политике. Как ты можешь выдвигать подобные обвинения против того, кто спас мою жизнь?"

    elif d_pts >= 1:
        c fierce narrowed unhappyopen2 "Мой брат тут {i}ни в чём не виноват{/i}. Он мог бы позволить им убить меня, но благодаря ему я жива!"
    else:

        c sad open smile1 "Я знаю, что это всё кажется несправедливым, но я уже смирилась с этим. Дела при дворе никогда не делятся на просто хорошие и плохие. И мне повезло, что я покинула замок живой."

    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen

    e "Помнишь, я сказала, что ты добрая и хорошая?"
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c neutral wide unhappyopen "........."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e lowered down frown "Я изменила своё мнение. Ты слепая дура."
    e sad closed "...Насколько я молчалива, настолько же ты слепа. И {i}в упор не замечаешь{/i} эгоизм, царящий в этом мире."
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c sideeye sad frown "Что ты имеешь в виду?"
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    e neutral frown "То и имею. Верь в своего брата, сколько хочешь, но ты не можешь отрицать, что в моих словах истина."
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c sad down pout "........."
    $ hide_alpha = 0
    hide screen fake_elowen
    "Элоўэн резко встала со стула и направилась к двери."
    e "Доброй ночи, принцесса."
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c angry narrowed2 tears1 unhappyopen "...Я больше не принцесса. Пожалуйста, не надо глумиться надо мной по этому поводу."
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    hide screen fake_elowen
    show cassidy frown tears2 with dis
    e sideeye lowered "Хм."
    $ hide_alpha = 0
    hide screen fake_cassidy

    stop music fadeout 2

    hide elowen with dissolve

    "И в один миг, Элоўэн ушла, растворившись в темноте."
    show cassidy closed2 sad worried at top:
        zoom 0.7
        yoffset -100
    with dissolve
    "Кэссиди обхватила руками туловище, обняв саму себя, чтобы успокоиться после того, как Элоўэн так неожиданно вышла из себя."
    scene black with Dissolve(1)
    "Не в состоянии успокоиться, она сильно сжала глаза."

    if d_pts >= 1:
        c_t "О, Александр, если бы только она знала тебя так же хорошо, как я... Тогда она бы поняла..."
    else:

        c_t "О, Элоўэн... Почему?.."

    scene sky evening orange
    show evening
    with Dissolve(2)
    scene sky night clear
    show night
    with Dissolve(2)
    scene sky
    show daytime
    with Dissolve(2)

    jump day4

label day4:

    $ save_name = "День четвёртый"

    play music "sound/madbox.ogg"
    scene black with Dissolve(2)

    window hide None
    poem "\n\n\n{w=0.5}Есть нечто ценное, что нельзя купить," with Dissolve(0.5)
    poem "И можно вечность о нём просить."
    poem "О чём говорю я — тому нет цены,"
    poem "Да и денег не нужно — чтоб прощённым быть."
    play sound "sound/thump.ogg"
    poem "\n\n{size=+15}{cps=10}День четвёртый.{/cps}{/size}"

    nvl clear

    postnvl "{nw}"

    stop music fadeout 4

    scene sky with Dissolve(2)
    scene exteriorhouse with Dissolve(2)
    scene room with Dissolve(2)

    window auto

    "Едва заснувшую Кэссиди разбудили яркие лучи солнца."
    show cassidy fierce closed1 pout at top:
        zoom 0.7
        yoffset -100
    with dissolve
    c "Ох-х..."
    show cassidy raised closed2 happyopen2 with dis
    "Она потянулась, выгнув спину."
    show cassidy neutral sideeye worried with dis
    "Наконец, она взглянула на входную дверь."
    "Под дверью письма уже не было."
    show black behind cassidy:
        alpha 0.5
    show cassidy glow catface open
    with dissolve
    c_t "Похоже, его забрали ночью... Какие же прилежные у моего брата агенты."

    play music "sound/troubleinparadise.ogg"
    c_t "{i}«Ты слепая дура».{/i}"
    hide black
    show cassidy normal sad down worried
    with dissolve
    "Воспоминания о вчерашнем споре с Элоўэн в одно мгновение взбудоражили принцессу."
    c "Не могу поверить, что я рассказала такую тайну кому-то, кого едва знаю..."


    menu:
        choice "Кэссиди была озадачена как странным поведением Элоўэн, так и своим."
        with ctransition
        "«Я так потрясена!»":
            show black behind cassidy:
                alpha 0.5
            show cassidy glow
            with dissolve
            c_t "Я так потрясена! Я думала, что она учтива и благовоспитана, но она разъярилась вчера не на шутку, и эо было весьма неуместно."
        "«Уверена, у неё были причины так говорить».":

            $ u_pts += 1
            show black behind cassidy:
                alpha 0.5
            show cassidy glow
            with dissolve
            c_t "Элоўэн была так расстроена... Может, она сама прошла через что-то похожее? И мой слепой оптимизм напомнил ей о тех событиях."
            c_t "Уверена, она просто переживает за меня. Похоже, я во всех пробуждаю жалость."
            c_t sweatdrop closed2 smile1 "Оно и понятно... Боюсь, я слишком часто выгляжу совершенно беспомощной."
            if not "2" in happenings:
                $ happenings.append("2")

    hide black
    show cassidy normal
    with dissolve

    if u_pts >= 1:
        c neutral none sideeye unhappyopen "Надо будет спросить у неё, как она жила раньше. Мы так мало друг о друге знаем. Не удивительно, что она может так резко на что-то реагировать."
        c pout "Ведь человек может делать выводы только основываясь на имеющемся опыте и знаниях."

    elif d_pts >= 1:
        c none fierce sideeye frown "На чём бы её мнение ни основывалось, она не должна была так реагировать. Она не знает Александра, и она не может его понять. Но я понимаю."
    else:

        c none fierce sideeye worried "Я едва знаю эту женщину. Может, ей свойственно такое поведение."
        c raised wide unhappyopen2 sweatdrop "...Боже, в таком случае, это просто ужасно!"
        $ happenings.append("10")

    stop music fadeout 2
    play sound "sound/knock.ogg"

    hide cassidy with dissolve

    "И вот, раздался стук в дверь."
    "Учитывая, сколько времени прошло с последнего привоза, и то, что Элоўэн наверняка бы крикнула, что она пришла, Кэссиди пришла к единственному выводу."
    "Перед тем, как открыть дверь, она подождала около десяти минут."
    "Таковы были правила. Принцесса не знала, кого посылает к ней брат, а посыльный не знал, кому он доставляет товар."
    "Королевская семья Веромира довольно сильно выделялась своей внешностью. И в то же время нельзя было допустить, чтобы слишком много людей знали, что это за женщина, или где она живёт."

    scene exteriorhouse with area_move

    show crate with dissolve

    "Когда она наконец позволила себе открыть дверь, она увидела перед собой деревянный ящик, не похожий ни на один из тех, что приходили ей ранее."
    "Наверху содержимого ящика лежал запечатанный конверт. Кэссиди сразу же узнала грубый почерк."

    hide crate with dissolve

    play music "sound/memory.ogg"

    $ letter_text = "Сестра моя,\n\n        Рад слышать, что ты успешно приспосабливаешься к жизни в том доме в лесу. Учитывая твой прежний образ жизни, без сомнения, ты там сталкиваешься со множеством трудностей. Но мы все должны справляться с тем, что имеем. Я знаю, что у тебя слишком много времени, которое не на что тратить, так что я отправил тебе побольше книг.\n        Возможно, когда-нибудь, тебя ещё выдадут замуж во благо нашего королевства. И поэтому крайне важно, чтобы ты сохраняла острый ум и натруженные руки."

    show screen letter
    pause
    hide screen letter

    "Последняя часть, похоже, была дописана позже, поскольку почерк немного отличался:"
    "«Я часто думаю о тебе. И ещё чаще мне неспокойно за тебя. Будь осторожна в лесу, и, хоть я и знаю, как для тебя это сложно, ни с кем не общайся»."
    "«Пожалуйста, дождись моего следующего письма. Твой верный брат,\n\nА.»."

    "Она несколько раз перечитывала письмо, пытаясь изо всех сил впитать всю помещённую в него привязанность."

    show cassidy closed2 catface sweatdrop at top:
        zoom 0.7
        yoffset -100
    with dissolve
    c "Хах... Александр всегда был немного неловок."
    c raised narrowed none "Уверена, последняя часть была написана с неохотой после того, как кто-то из его советников указал ему на сухость всего письма."
    show cassidy neutral down smile1 with dis
    "Она улыбнулась и провела пальцами по строке со словами «Я часто думаю о тебе»."
    show cassidy sideeye worried with dis

    menu:
        choice "Но потом она вспомнила предложение про замужество."
        with ctransition
        "«Как заботливо с его стороны».":
            $ d_pts += 1
            show black behind cassidy:
                alpha 0.5
            show cassidy glow
            with dissolve
            c_t neutral open smile1 "Уверена, Александр не хочет, чтобы я всю жизнь просидела здесь. Как заботливо с его стороны найти способ вытащить меня из изгнания."
            c_t sad closed2 sweat "...Пускай даже через политический брак... Это всё равно лучше, чем скрываться здесь."

        "«Так {i}вот{/i} из-за чего он оставил меня в живых?»" if d_pts <= 0:
            $ d_pts -= 1
            show black behind cassidy:
                alpha 0.5
            show cassidy glow
            with dissolve
            c_t "Может ли это быть причиной, почему он оставил меня в живых?"
            c_t down worried sad tears1 "Я для него лишь выгодная пешка?"
            "Эта мысль разъедала её, и Кэссиди едва сдерживала слёзы. Её брат ещё никогда не рассказывал так прямо о своих намерениях."
            $ happenings.append("11")

        "«Я не хочу выходить замуж...»" if d_pts > 0:
            show black behind cassidy:
                alpha 0.5
            show cassidy glow
            with dissolve
            c_t down lipbite lowered "Я никогда не думала о замужестве, даже до изгнания."
            c_t "Может ли вообще знатный человек или, тем более, царская особа быть в мире с мыслью о том, что его будущая жена жила в лесу?"
            c_t sideeye worried sweatdrop "И могу ли я сама быть уверенной в себе при таком раскладе?"
            $ happenings.append("11")

    show cassidy none with dis
    "Это письмо не подняло ей настроение так, как делали это прошлые письма Александра. Содержимое письма было гнетущим для неё."
    c_t closed1 sad pout "Конечно же, я должна быть в какой-то степени полезной для королевства. Иначе зачем мне оставаться в живых? Если я могу принести пользу, пускай и в роли опальной принцессы..."
    show cassidy sideeye with dis
    "Кэссиди вздохнула. Она не хотела, не могла закончить эту мысль."

    play music "sound/silk.ogg" fadeout 2

    hide black
    show cassidy normal raised wide unhappyopen
    with dissolve

    if d_pts <= 2 and u_pts >= 1:
        "Внезапно ей сильно захотелось вновь увидеть Элоўэн."

        c neutral open worried "Я найду её. Я должна."
        hide cassidy with dissolve
        "Компания Элоўэн определённо помогла бы ей справиться с текущим душевным состоянием. Во всяком случае, принцесса так думала."
        "Она незамедлительно поставила ящик в угол комнаты и пошла искать Элоўэн."

        scene forest:
            xalign 0.0
        with area_move

        "После долгого и безрезультатного брождения по лесу, она подошла к вистерии."

        $ happenings.append("12")

        show first meeting1 with Dissolve(1)
    else:

        "Как вдруг, Кэссиди услышала шуршание, раздавшееся совсем недалеко от неё."
        c mismatched narrowed pout "...Хм-м?.."
        show cassidy at topright:
            zoom 0.54
            yoffset 0

        show elowen at topleft:
            zoom 0.54
        with dissolve
        "Она оторвала взгляд от письма и увидела Элоўэн, стоящую в нескольких шагах от неё."
        show cassidy raised wide unhappyopen with dis

    c "...Элоўэн."
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e "Принцесса."
    if not "12" in happenings:
        show cassidy down sad pout with dis
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    hide screen fake_cassidy
    c "Ну какая я тебе принцесса?"
    if "12" in happenings:
        $ hide_alpha = 0
        hide screen fake_elowen
        scene forest:
            xalign 0.0
        with Dissolve(1)

        show cassidy down sad pout at topright:
            zoom 0.54

        show elowen at topleft:
            zoom 0.54
        with dissolve
    else:
        $ fake_c_text = _last_say_what
        show screen fake_cassidy
        hide screen fake_elowen

    e sideeye lowered "То, что ты больше не живёшь во дворце, не значит, что ты больше не принцесса."
    $ hide_alpha = 0
    hide screen fake_cassidy
    show cassidy frown with dis
    "Кэссиди вновь вспомнились слова «выдадут замуж» из письма."

    "Элоўэн была права. Кэссиди всё ещё считалась принцессой в том смысле, в каком её всё ещё можно было использовать по упомянутому назначению."
    "Они долго стояли молча."
    "Они обе, без сомнения, думали в тот момент о споре, разразившемся между ними. Споре, который они ещё не разрешили."
    show cassidy open unhappyopen with dissolve
    c "Прости меня."
    show elowen wide
    show cassidy smile1
    with dis
    "Глаза Элоўэн расширились на совсем незаметную долю, но сверлящая её лицо взглядом Кэссиди  всё же это заметила."
    c "Прежде всего, я вовсе не должна была обременять тебя подробностями своего положения."

    if u_pts >= 1:
        c "Но ты просто беспокоилась за меня... Я должна была быть более чуткой в своих высказываниях."
    else:

        c sideeye "Что ж, ты была несколько резка, да, но... Всё равно, прости меня."

    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e sideeye "Нет..."
    $ fake_e_text = _last_say_what
    hide screen fake_cassidy
    show screen fake_elowen
    c neutral open unhappyopen "М-м?"

    if u_pts >= 1 and d_pts <= 2:
        $ hide_alpha = 0
        hide screen fake_elowen
        show elowen open smile2
        show cassidy dilated blush
        with dis1
        "И тут на лице Элоўэн показалась мягкая улыбка. Она легко засмеялась."
        show cassidy down lowered lipbite with dis
        "Сердце бывшей принцессы забилось радостью, и она совсем забыла про письмо своего брата."
        $ happenings.append("13")
        show elowen closed smile1 with dis
    else:
        show elowen closed lowered with dis
        $ fake_c_text = _last_say_what
        show screen fake_cassidy
        hide screen fake_elowen

    e "Ничего. Похоже, что я тоже по-своему дурочка."

    $ hide_alpha = 0
    hide screen fake_cassidy

    scene sky evening orange
    with Dissolve(1)
    "Напряжение в воздухе спало."
    "Дамы приятно провели остаток вечера вместе."

    stop music fadeout 2
    scene sky night clear with fadeup

    "А ночью Кэссиди быстро заснула, довольная тем, как провела день."

    jump day5

label day5:

    $ save_name = "День пятый"

    play music "sound/madbox2.ogg"

    scene black with Dissolve(2)

    window hide None
    poem "\n\n\n{w=0.5}Любовные струны не видны зачастую" with Dissolve(0.5)
    poem "Но могут уже они виться вокруг."
    poem "И коли опутан ты напрочно ими,"
    poem "Неизбежно событий развитье, мой друг."
    play sound "sound/thump.ogg"
    poem "\n\n{size=+15}{cps=10}День пятый.{/cps}{/size}"

    nvl clear

    postnvl "{nw}"

    stop music fadeout 2

    scene forest with Dissolve(2)
    show elowen at topleft:
        zoom 0.54

    show cassidy at topright:
        zoom 0.54
    with dissolve

    window auto

    play music "sound/morning.ogg" fadein 1

    c closed2 happyopen2 "Ох, какой прекрасный день!"
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e sideeye "...Воистину."
    $ hide_alpha = 0
    hide screen fake_cassidy
    show cassidy open catface with dis
    "Для Кэссиди был неожиданностью столь ранний визит Элоўэн, которая уже стояла под дверью."

    show black behind cassidy:
        alpha 0.5
    show cassidy glow
    with dissolve

    c_t "Элоўэн даже не постучалась ни разу. Дурашка."
    show cassidy narrowed mismatched pout with dis
    c_t "Интересно, если бы я её не заметила и не открыла дверь, она бы ушла?"
    hide black
    show cassidy normal
    with dissolve
    "Эта мысль мучила Кэссиди почти так же сильно, как и вопрос о том, так же ли сильно Элоўэн тосковала по её компании, как она по компании Элоўэн."

    scene forest with dissolve

    "Некоторое время дамы провели в раздумьях о том, чем им заняться. В конце концов они решили отправиться на прогулку."
    "Следующие несколько часов они гуляли по лесу, останавливаясь то там, то сям, чтобы подобрать грибы и ягоды."

    scene forest evening with dissolve
    show elowen at topleft:
        zoom 0.54

    show cassidy at topright:
        zoom 0.54
    with dissolve

    play music "sound/solace.ogg" fadeout 2

    e raised unhappyopen "Он ядовитый. Не трогай его."
    show elowen frown
    show cassidy raised wide unhappyopen2 sweatdrop
    with dis
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c "А, д-да!"
    $ hide_alpha = 0
    hide screen fake_elowen
    "Кэссиди резко одёрнула свою руку."
    show cassidy pout open
    show elowen closed lowered worried
    with dis
    e "Увлажнение ядовитыми соками не пойдёт на пользу твоей коже."
    show cassidy none sideeye neutral with dis
    "Кэссиди бросила испуганный взгляд на лицо Элоўэн, но оно оказалось таким же невозмутимым, как и всегда."

    show black behind cassidy:
        alpha 0.5
    show cassidy glow
    with dissolve

    menu:
        c_t_choice "Ядовитые?.."
        with ctransition
        "«Ты уверена в этом?»":
            hide black
            show cassidy normal
            with dissolve
            c raised unhappyopen "Ты уверена, что они ядовиты?"
            $ hide_alpha = 1
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            e narrowed smirk "Без капли сомнения. Я в этом лесу живу уже... очень долго."
            $ hide_alpha = 0
            hide screen fake_cassidy
            show elowen sideeye worried
            show cassidy lowered down frown
            with dis
        "«Откуда ты столько знаешь?»":

            $ k_pts += 1
            hide black
            show cassidy normal
            with dissolve
            c open neutral smile2 "Ты так много знаешь о местных флоре и фауне! Откуда ты столько узнала?"
            $ hide_alpha = 1
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            e narrowed frown neutral "Я много лет здесь живу. И за это время я повидала множество интересных вещей."
            e "Много узнавала от людей, заходивших в лес."
            e closed unhappyopen lowered "И всё же..."
            $ fake_e_text = _last_say_what
            hide screen fake_cassidy
            show screen fake_elowen
            c mismatched worried "М-м?"
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            hide screen fake_elowen
            e neutral open frown "Я жила одна. Много видела, но так мало переживала сама."
            $ fake_e_text = _last_say_what
            hide screen fake_cassidy
            show screen fake_elowen
            c sad open frown "Элоўэн..."
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            hide screen fake_elowen
            e sideeye unhappyopen "Я давно чувствую себя кем-то, кто со стороны смотрит на мир, к которому не может сам прикоснуться."
            $ hide_alpha = 0
            hide screen fake_cassidy
            $ happenings.append("14")
            show elowen frown with dis

    "Перед Кэссиди предстал грустный образ Элоўэн, который она доселе не видела, и даже не думала, что Элоўэн способна на подобные эмоции."
    "Та Элоўэн, которую она знала, была столь сдержана, что ни одна эмоция не проявлялась на её лице."
    show black behind cassidy:
        alpha 0.5
    show cassidy glow
    with dissolve
    c_t "Действительно, не так уж хорошо я её знаю. Может, она так сдержана только с теми, с кем мало знакома."
    hide black with dissolve
    c normal neutral open unhappyopen "А что заставило тебя заговорить со мной?"
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e open "С тобой?"
    $ fake_e_text = _last_say_what
    hide screen fake_cassidy
    show screen fake_elowen
    c down frown lowered "Понимаешь,.."
    $ hide_alpha = 0
    hide screen fake_elowen

    show cassidy smile1 blush with dis
    "Кэссиди вспомнила их первую встречу, то, как её сердце подпрыгивало при виде Элоўэн."
    "И Элоўэн знала всё о ней, из чего следует, что она некоторое время наблюдала за принцессой."
    show cassidy none open smile2 with dis
    c "Ты могла не садиться тогда под дерево, а продолжать наблюдать издалека."
    c "Но ты появилась под вистерией. И заговорила со мной."
    if u_pts >= 1 and d_pts <= 2 and k_pts >= 2:
        show black behind cassidy:
            alpha 0.5
        show cassidy glow down blush
        with dissolve
        c_t "И... я рада, что она это сделала... Но я боюсь, что она может назвать меня глупой за подобные слова."
        hide black
        show cassidy normal
        with dissolve
    e neutral open smile1 "Я посчитала тебя элегантной и красивой."
    show cassidy open none unhappyopen raised with dis
    "То, как прямо Элоўэн произнесла это, поразило Кэссиди. Она, конечно же, была польщена, но в то же время отчасти... обеспокоена."
    "Красота — это не что-то вечное. Это весьма шаткий фундамент для {i}любых{/i} отношений."
    "Если бы кто-то при дворе отметил красоту Кэссиди, она бы спокойно отреагировала."
    if u_pts >= 1 and d_pts <= 2 and k_pts >= 2:
        show cassidy sad down smile1 with dis
        "Но перед ней сейчас стояла Элоўэн. Женщина, к которой она всё больше наполнялась тёплыми чувствами."
    else:
        show cassidy mismatched narrowed pout with dis

    c "«Посчитала»? В прошедшем времени? Какого же ты мнения обо мне сейчас?"
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e sideeye frown "Я всё ещё считаю тебя очень красивой. Но элегантности и изящества в тебе вовсе не так много."
    e closed smile1 "Ты далеко не столь манерная принцесса, за какую я тебя сперва приняла."
    $ hide_alpha = 0
    hide screen fake_cassidy
    show cassidy down lowered pout sweatdrop with dis
    "Кэссиди опустила глаза и поморщилась, её губы слегка надулись."
    show black behind cassidy:
        alpha 0.5
    show cassidy glow
    with dissolve
    c_t "Как я и думала..."
    c_t smile1 closed2 sad "Вполне ожидаемо! Некто столь изящный, как Элоўэн, конечно же посчитает меня недо—"
    hide black
    show cassidy normal
    with dissolve

    if u_pts >= 1 and d_pts <= 2 and k_pts >= 2:

        e "Ты оказалась не такой, как я ожидала, но... Думаю, так может быть даже лучше."
        show cassidy wide raised none unhappyopen with dis
        "Кэссиди медленно подняла голову, в её глазах можно было увидеть, что она не может поверить в слова Элоўэн."

        c "Даже лучше?"
        $ hide_alpha = 1
        $ fake_c_text = _last_say_what
        show screen fake_cassidy
        e open smile2 raised "Ты постоянно превосходишь мои ожидания."
        e lowered sideeye frown "И я вот думаю... Было ли бы так же с другими людьми, если бы я их допускала так же близко к себе."
        $ fake_e_text = _last_say_what
        hide screen fake_cassidy
        show screen fake_elowen
        c sad wide unhappyopen2 "Ну—!"
        $ fake_c_text = _last_say_what
        show screen fake_cassidy
        hide screen fake_elowen
        e wide raised "М-м?"
        $ fake_e_text = _last_say_what
        hide screen fake_cassidy
        show screen fake_elowen
        c smile2 narrowed "Это может звучать эгоистично, но..."
        c blush "Я рада, что ты не подпускала к себе никого до меня. Мне приятно быть единственным человеком, который стал тебе близок."
        c narrowed2 smile1 "...Прости, это может звучать довольно... некрасиво."
        $ fake_c_text = _last_say_what
        show screen fake_cassidy
        hide screen fake_elowen
        e neutral open "...Нет."
        e lowered closed unhappyopen "Не хуже, чем я."
        show elowen frown with dis

        $ happenings.append("15")

        $ hide_alpha = 0
        hide screen fake_cassidy

    hide elowen
    show elowend1 closed at topleft:
        zoom 0.54
    with Dissolve(1)

    show cassidy none raised open unhappyopen with dis
    "Вдруг Элоўэн предстала неверноятно измученной в глазах Кэссиди."
    show cassidy wide with dis
    "Принцесса словно посмотрела сквозь идеально лежащую вуаль и увидела уставшую, голодную женщину."

    c sad "Ты в порядке?"
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    show elowend1 wide with dis
    e "{size=+10}!{/size}"
    $ hide_alpha = 0
    hide screen fake_cassidy

    hide elowend1
    show elowen wide raised behind cassidy at topleft:
        zoom 0.54
    with dis

    "Через мгновение Элоўэн снова приняла свой обычный вид."

    e sad down worried "Всё хорошо."
    show cassidy open frown with dis
    "Несмотря на это, Кэссиди не могла избавиться от чувства, что что-то не так."
    c "Уверена? Ты выглядишь усталой."
    "Элоўэн некоторое время молчала."
    e "...Да."
    e neutral sideeye frown "Может... Может быть я устала."
    e lowered closed "Прости, я нечасто бываю в полдень на солнце."

    "В этот момент Кэссиди осознала, что никогда ещё не видела Элоўэн по утрам."


    show black behind cassidy:
        alpha 0.5
    show cassidy glow
    with dissolve
    c_t worried down "Может, она «сова»? Я это не предвидела."
    c_t "А сейчас я её позвала гулять... Под палящим солнцем..."
    c_t closed1 "Как же я не подумала!"

    hide black
    show cassidy normal open unhappyopen with dis
    with dissolve
    c "Элоўэн..."

    show cassidy worried with dis
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e open "Да?"

    show elowen wide worried raised with dis
    $ fake_e_text = _last_say_what
    hide screen fake_cassidy
    show screen fake_elowen
    c open smile2 lowered "Не хочешь сегодня остаться у меня на ночь?"

    show cassidy smile1 with dis
    $ fake_c_text = _last_say_what
    hide screen fake_elowen
    show screen fake_cassidy
    e unhappyopen "Что?"

    show elowen frown with dis
    $ fake_e_text = _last_say_what
    hide screen fake_cassidy
    show screen fake_elowen
    c closed2 happyopen fierce "Ну, я беспокоюсь за тебя. Да и в любом случае нелегко жить даме одной в лесу."

    show cassidy smile1 down with dis
    $ hide_alpha = 0
    hide screen fake_elowen
    "Она это прекрасно знала."

    show elowen neutral open
    c open smile2 "Мне было бы гораздо спокойнее, если бы ты переночевала у меня."
    c happyopen2 "Уютненько посидим вместе, поужинаем ."
    show cassidy lowered worried down with dis
    "Она не ожидала, что Элоўэн согласится. Не Элоўэн, которая так категорично ответила на предложение пару дней назад."
    show elowen closed with dis
    "Но всё же..."
    e unhappyopen neutral "...Хорошо."

    show elowen frown with dis
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c wide happyopen2 blush raised "Серьёзно?!"

    show cassidy smile2 with dis
    $ fake_c_text = _last_say_what
    hide screen fake_elowen
    show screen fake_cassidy
    e raised narrowed unhappyopen "А что, мне лучше пойти к себе домой?"

    show elowen smirk with dis
    $ fake_e_text = _last_say_what
    hide screen fake_cassidy
    show screen fake_elowen
    c closed2 blushforclosed2 happyopen "Н-нет, я просто боялась, что ты не согласишься."
    c sideeye unhappyopen blush lowered "Я понимаю, что это не очень... изящно... так прямо тебя приглашать."

    show cassidy pout with dis
    show elowen closed smile1 lowered blush with dis
    $ hide_alpha = 0
    hide screen fake_elowen
    "После этих слов Элоўэн впервые за сегодня улыбнулась."
    show elowen dilated with dis
    show cassidy dilated worried with dis
    "Сердце Кэссиди запрыгало от счастья."
    show cassidy happyopen2 wide with dis
    e closed happyopen "Это честь для меня — составить тебе компанию."
    show cassidy smile1 with dis
    e dilated smile2 "...И это может быть полезно для нас обеих."

    show elowen smile1 with dis
    "Как и всегда, Кэссиди была чересчур рада услышать последнее."
    stop music fadeout 2
    show cassidy blushforclosed2 closed2 with dis
    "В нетерпении вечера с персоной, которая ей теперь больше всего по душе, Кэссиди изменила курс их прогулки в сторону дома."

    scene exteriorhouse evening with area_move
    scene kitchen evening with area_move
    play music "sound/moon.ogg"
    "Когда они вошли, Кэссиди закрыла дверь и пошла на кухню, чтобы разложить по полкам собранные по пути фрукты и ягоды."
    show elowen neutral smile1 at topleft:
        zoom 0.54
    show cassidy closed2 catface at topright:
        zoom 0.54
    with dissolve
    e sideeye unhappyopen "Я могу помочь с чем-нибудь?"

    show elowen open smile1 with dis
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c fierce happyopen open "Нет, я всё сделаю! Просто садись, отдыхай."
    c sad smile2 "Ты правда выглядишь уставшей."

    show cassidy smile1 with dis
    $ fake_c_text = _last_say_what
    hide screen fake_elowen
    show screen fake_cassidy
    e smile2 down "Ладно."
    $ hide_alpha = 0
    hide screen fake_cassidy

    hide elowen with dissolve

    if u_pts >= 1 and d_pts <= 2 and k_pts >= 2:
        "Раскладывая всё на кухне, Кэссиди не могла не думать о том, что Элоўэн сказала ранее."
        show black behind cassidy:
            alpha 0.5
        show cassidy glow
        with dissolve
        c_t neutral "Она сказала... что я ей нравлюсь такой, какая я есть."
        c_t lowered blush "Это так приятно."
        hide black
        show cassidy normal
        with dissolve
        "В глубине души она почувствовала тепло и удовлетворение. То, что она не чувствовала уже давно"
        scene room evening with area_move
        "Через некоторое время она вернулась в конату, где сидела Элоўэн. В руках Кэссиди несла две чашки чая."
        c "Оу!"
        show elowen closed smile1 neutral at topleft:
            zoom 0.54

        show cassidy wide raised unhappyopen at topright:
            zoom 0.54
        with dissolve
        "Она увидела Элоўэн спящей на диване."

        show black behind cassidy:
            alpha 0.5
        show cassidy glow
        with dissolve

        c_t closed2 smile1 "Бедняжка. Она, должно быть, совсем вымоталась."
        hide black
        show cassidy normal open
        with dissolve
        "Кэссиди увидела локон волос, лежащий на лице Элоўэн. Она потянулась к нему и убрала его Элоўэн за ухо."
        show black behind cassidy:
            alpha 0.5
        show cassidy glow
        with dissolve
        c_t blushforclosed2 closed2 catface "Она выглядит такой невинной, когда спит."
        hide black
        show cassidy normal open blush
        with dissolve
        "Похихикивая, Кэссиди села другую часть дивана, и не нарушая сна Элоўэн принялась читать книгу."

        $ happenings.append("16")

    scene sky night clear with dissolve
    "Вскоре стемнело, и настало время ужина."

    scene room night lights with dissolve

    show elowen down frown at topleft:
        zoom 0.54

    show cassidy unhappyopen wide raised at topright:
        zoom 0.54
    with dissolve

    show black behind cassidy:
        alpha 0.5
    show cassidy glow
    with dissolve


    if not "8" in happenings:
        c_t "Элоўэн часто ничего не ест. Не удивительно, что она такая худая!"
    else:
        c_t "Она всё ещё ничего не ест... Она, конечно, выпила немало чая до этого, но..."
        show cassidy down lowered worried
        c_t "Может, она иностранка? Может, её вежливость не позволяет ей сказать, что ей не нравится еда?"

    hide black
    show cassidy normal worried
    with dissolve
    show elowen closed with dis
    "Элоўэн, в неведении, что за её действиями так пристально наблюдают, манерно попивала воду из стакана."

    show elowen open with dis
    c open smile2 raised "Ты сыта?"

    show cassidy worried with dis
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    e unhappyopen "Я довольна."

    show elowen down frown
    $ fake_e_text = _last_say_what
    hide screen fake_cassidy
    show screen fake_elowen
    if "8" in happenings:
        c sad unhappyopen "Как так, ты же ничего не ела?"

        show cassidy lipbite with dis
        $ fake_c_text = _last_say_what
        hide screen fake_elowen
        show screen fake_cassidy
        e sideeye unhappyopen "Я просто не голодна сейчас."

        $ fake_e_text = _last_say_what
        hide screen fake_cassidy
        show screen fake_elowen
    else:
        c unhappyopen sad "Ты так мало съела, Я беспокоюсь о твоём самочувствии."

        show cassidy frown with dis
        $ fake_c_text = _last_say_what
        hide screen fake_elowen
        show screen fake_cassidy
        e narrowed unhappyopen "Я поела достаточно. И я не люблю что-либо делать сверх меры."

        $ fake_e_text = _last_say_what
        hide screen fake_cassidy
        show screen fake_elowen
    show elowen frown open with dis
    c down neutral unhappyopen "Понятно..."

    show cassidy worried with dis
    $ hide_alpha = 0
    hide screen fake_elowen
    "По тону Элоўэн было ясно, что спорить с ней бесполезно."

    show cassidy open worried lowered with dis
    "После ужина Кэссиди убрала тарелки и начала готовить комнату ко сну."
    "Дом был небольшим, поэтому гостиная являлась одновременно и спальней."
    show cassidy sideeye with dis
    "И если для одного человека места было предостаточно, то размещение второго уже создавало некоторые проблемы."
    c neutral sweatdrop unhappyopen "Тут всего одна кровать..."

    show cassidy worried with dis
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    if "16" in happenings:
        e closed unhappyopen "Я могу поспать на диване."
        e narrowed fierce "Я же уже спала на нём."

        show elowen frown with dis
        $ fake_e_text = _last_say_what
        hide screen fake_cassidy
        show screen fake_elowen
        c sad unhappyopen down none "Прости меня ещё раз, что не разбудила тебя! Ты просто... выглядела такой умиротворённой."
        c closed2 "Я просто не смогла тебя потревожить."

        show cassidy frown open with dis
        $ fake_c_text = _last_say_what
        hide screen fake_elowen
        show screen fake_cassidy
        e sideeye unhappyopen sad "Мне очень неловко, что я позволила тебе застать меня в таком состоянии."
        e neutral down "Я только боюсь, что..."

        show elowen frown with dis
        $ fake_e_text = _last_say_what
        hide screen fake_cassidy
        show screen fake_elowen
        c raised unhappyopen wide "М-м?"

        show cassidy frown with dis
        $ fake_c_text = _last_say_what
        hide screen fake_elowen
        show screen fake_cassidy
        e closed unhappyopen lowered "Ничего, не важно. Я с радостью посплю на диване или даже на полу. Я не придирчива."

        show elowen frown with dis
        $ fake_e_text = _last_say_what
        hide screen fake_cassidy
        show screen fake_elowen
    else:
        e smile2 closed neutral "Я с радостью посплю на диване или даже на полу. Я не придирчива."
        $ fake_e_text = _last_say_what
        hide screen fake_cassidy
        show screen fake_elowen

        show elowen open smile1 with dis
    c wide unhappyopen raised "О, нет, так нельзя! Ты же гость."

    show cassidy catface
    $ fake_c_text = _last_say_what
    hide screen fake_elowen
    show screen fake_cassidy
    e worried sideeye "........."

    $ fake_e_text = _last_say_what
    hide screen fake_cassidy
    show screen fake_elowen
    c worried sideeye "........."

    $ hide_alpha = 0
    hide screen fake_elowen
    "Кэссиди сглотнула комок в горле. По правде говоря, у неё был {i}ещё один вариант{/i} на уме, который ей нравился куда больше."
    c blush happyopen dilated "Мы можем... вместе спать на кровати. Там предостаточно места для двоих."

    show cassidy open worried
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    hide screen fake_elowen
    show screen fake_cassidy
    e fierce smile2 wide "Хм, а чего это {i}ты{/i} не хочешь устроиться на диване?"

    show elowen smile1 neutral
    $ fake_e_text = _last_say_what
    hide screen fake_cassidy
    show screen fake_elowen
    c wide unhappyopen raised "...Ам..."

    show elowen raised lipbite
    $ hide_alpha = 0
    hide screen fake_elowen
    show cassidy down frown sad
    "Кэссиди испуганно замолчала и прикусила губу, ошеломлённая собственной неучтивостью."

    show cassidy wide neutral with dis
    e happyopen closed "Я просто дразню тебя."

    show cassidy neutral blush happyopen with dis
    e dilated smile2 blush "...Если ты не возражаешь, я с радостью разделю с тобой кровать."

    show elowen smile1 with dis
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show screen fake_elowen
    c closed2 blushforclosed2 happyopen2 "Не может быть ничего приятнее для меня, чем близость к тебе!.."
    c lowered sideeye smile2 "Ну то есть... Да. Замечательно. Пойду, тогда, возьму ещё одну подушку."
    $ hide_alpha = 0
    hide screen fake_elowen

    show cassidy fierce worried blush with dis
    "Кэссиди, вся красная от смущения, пошла в кладовку за подушкой."











    show sleepover_a
    show sleepover_b
    show sleepover_c
    scene sleepover with Dissolve(2):
        zoom 0.54

    scene black
    show sleepover_cg c_browdown c_blush c_sweat c_open:
        zoom 0.54
    with Dissolve(2)

    c "Тебе не тесно? Достаточно места?"
    $ hide_alpha = 1
    $ fake_c_text = _last_say_what
    show screen fake_cassidy
    show sleepover_cg c_closed e_open e_browdown
    e "Да, всё хорошо."
    show sleepover_cg e_away e_blush
    e "Честно говоря, я не против того, что мы так близко друг к другу лежим."
    $ hide_alpha = 0
    hide screen fake_cassidy
    show sleepover_cg e_smile -e_blush -c_sweat -c_blush -c_browdown:
        zoom 0.8 xalign 0.5 yalign 0.2
        xoffset 150 subpixel True
        ease 5 xoffset 100
    with Dissolve(2)
    "Элоўэн смотрела словно куда-то вдаль."
    show sleepover_cg e_open e_normal
    e "Я так долго была одна... Пока не появилась ты."
    $ hide_alpha = 1
    $ fake_e_text = _last_say_what
    show sleepover_cg e_smile c_open
    show screen fake_elowen
    c "Как так получилось, что ты теперь живёшь в лесу? Где твоя семья?"
    $ fake_c_text = _last_say_what
    hide screen fake_elowen
    show screen fake_cassidy
    show sleepover_cg e_open e_away c_closed e_browup
    e "........."
    $ hide_alpha = 0
    hide screen fake_cassidy
    show sleepover_cg c_sweat c_browdown e_smile
    menu:
        c_choice "Ох..."
        with ctransition
        "Что-то не так?":

            show black:
                alpha 0.5

            with dissolve
            show sleepover_cg e_smile c_closed
            c_t "Вроде бы, обычный вопрос, разве нет? Почему ей так трудно об этом говорить?"
            c_t "Впрочем, и моя-то ситуация была не такой уж простой..."
            hide black


            show sleepover_cg c_open
            c "Твоя семья... пропала?"
            show sleepover_cg c_closed e_normal
            "Элоўэн, сжав рот в пугающую прямую линию, смотрела на Кэссиди."
        "Наверное, она не может рассказать об этом.":

            $ u_pts += 1
            show sleepover_cg -c_browdown
            show black as dimmer:
                alpha 0.5

            with dissolve
            c_t "Наверное, она не просто не хочет мне рассказывать, а именно не может."

            c_t "Может, она по каким-то причинам не может распространяться об этом."
            show sleepover_cg c_browdown
            c_t "Было ли слишком неуместно с моей стороны спрашивать об этом?"
            hide black as dimmer
            show sleepover_cg c_open


            c "Прости. Тебе... трудно об этом говорить?"
            $ hide_alpha = 1
            $ fake_c_text = _last_say_what
            show screen fake_cassidy
            $ happenings.append("17")
    show sleepover_cg e_open e_browdown c_closed -c_sweat
    e "Это очень сложный вопрос. Я не знаю, с чего начать."
    $ hide_alpha = 0
    hide screen fake_cassidy 
    show sleepover_cg e_smile e_browup e_away
    "Она глубоко вздохнула."
    show sleepover_cg e_normal e_browdown e_open
    e "Я прожила здесь всю мою жизнь. Когда-то я была не одна, но..."
    show sleepover_cg e_smile e_away
    "Элоўэн остановилась и вздохнула."
    if k_pts >= 2:
        show sleepover_cg e_open e_browup
        e "Помнишь ту вистерию?"
        $ hide_alpha = 1
        $ fake_e_text = _last_say_what
        show screen fake_elowen
        show sleepover_cg c_open c_browup c_blush e_smile
        c "Конечно! Это моё любимое место во всём лесу."
        $ fake_c_text = _last_say_what
        hide screen fake_elowen
        show screen fake_cassidy
        show sleepover_cg c_smile e_open e_browup e_normal
        e "А ты заметила, что вокруг больше нет ни одной вистерии?"
        $ fake_e_text = _last_say_what
        hide screen fake_cassidy
        show screen fake_elowen
        show sleepover_cg c_open c_browdown c_sweat e_smile -c_blush
        c "Не обращала внимания, но теперь, когда ты сказала..."
        $ hide_alpha = 0
        hide screen fake_elowen
        show sleepover_cg c_closed
        show forest:
            xalign 0.0 yalign 0.5 subpixel True
            ease 15 xalign 0.5
        show black as dimmmer:
            alpha 0.5
        with Dissolve(1)
        "Кэссиди никогда ранее не думала об этом, но вспомнив, как выглядят те места, она поняла, что Элоўэн права."
        show sleepover_cg c_browup c_open -c_sweat
        c "Да, ты права. И почему же так?"
        $ hide_alpha = 1
        $ fake_c_text = _last_say_what
        show screen fake_cassidy
        show sleepover_cg e_away e_open e_browup c_closed
        e "Глубоко в чаще есть ещё более древняя вистерия, и на сегодняшний день эти две вистерии — единственные во всём лесу, и они при этом так далеко друг от друга."
        show sleepover_cg e_normal e_browdown e_blush
        e "Похожая ситуация и со мной."
        $ hide_alpha = 0
        hide screen fake_cassidy
        hide dimmmer
        hide forest
        show sleepover_cg e_smile
        "Такое изложение показалось для Кэссиди странным, но она всё равно кивнула в знак того, что она внимательно слушает и Элоўэн может продолжать."
    show sleepover_cg e_open e_browup -e_blush
    e "У меня когда-то тоже были родственники. Они уже давно... покинули эти края. Поэтому у меня теперь нет семьи."
    show sleepover_cg e_away e_browdown
    e "Конечно, мимо проходили люди, кто-то даже жил здесь, но они совершенно не были мне близки."
    show sleepover_cg:
        zoom 1.0 yoffset -120 subpixel True
        ease 5 yoffset -80
    with Dissolve(1)
    e "Я просто наблюдала за ними издалека, не вмешиваясь в их жизнь, и не скучала по ним, когда они уходили из моей."
    e "Так проходили годы."


    if u_pts >= 2 and d_pts <= 2 and k_pts <= u_pts:
        $ hide_alpha = 1
        $ fake_e_text = _last_say_what
        show screen fake_elowen
        show sleepover_cg e_smile c_open c_browup c_blush
        c "Ты больше никогда не будешь одна."
        $ hide_alpha = 0
        hide screen fake_elowen
        show sleepover_cg e_browup e_normal c_smile
        "Глаза Элоўэн погрустнели. Кэссиди подумала, что та сейчас расплачется, но Элоўэн лишь грустно улыбнулась."
        show sleepover_cg e_browdown e_blush e_open
        e "Понятно."
        $ happenings.append("18")

    scene sky night clear with close_eyes:
        zoom 1.2 yalign 1.0
        ease 10 yalign 0.5
    "Кэссиди придвинулась чуть ближе к ней, чтобы сопроводить свои слова милым жестом."

    "Так они и провели ночь вместе, за уютным разговором в компании друг друга."

    jump day6

label day6:

    $ save_name = "День шестой"




    play music "sound/madbox2.ogg"

    scene black with Dissolve(2)

    window hide None
    poem "\n\n\n{w=0.5}Коли солнце слепит в глаз," with Dissolve(0.5)
    poem "Жду я тучи, жду дождя."
    poem "Но когда ты, милая, уходишь"
    poem "Увидеть солнце вновь желаю я."
    play sound "sound/thump.ogg"
    poem "\n\n{size=+15}{cps=10}День шестой.{/cps}{/size}"

    nvl clear

    postnvl "{nw}"

    stop music fadeout 2

    scene sky with Dissolve(2)
    scene exteriorhouse with Dissolve(2)
    scene room with Dissolve(2)

    window auto

    "Кэссиди проснулась одна, кровать рядом с ней была холодна."

    show cassidy lowered down worried at top:
        zoom 0.7
        yoffset -100
    with dissolve

    play music "sound/moon.ogg"

    if u_pts <= 2 or k_pts >= 3:
        show black behind cassidy:
            alpha 0.5
        show cassidy glow
        with dissolve
        c_t "Она вновь умчалась утром..."
        c_t fierce closed1 "Что она может делать в такую рань?"
        hide black
        show cassidy normal narrowed2 unhappyopen with dis
        with dissolve
        c "...Это очень подозрительно."
        show cassidy worried with dis
        "Она уже не могла игнорировать грызущий её страх. Возможно, в следующий раз ей стоило спросить об этом Элоўэн."
    else:
        show black behind cassidy:
            alpha 0.5
        show cassidy glow down frown
        with dissolve
        c_t "Надеюсь, она в порядке."
        hide black
        show cassidy normal
        with dissolve

    if d_pts >= 2:
        c sideeye sweatdrop pout "С оставшимися продуктами надо быть осторожнее."
        c closed1 sad "Новые привезут ещё не скоро... Я не могу слишком часто устраивать пирушки с Элоўэн."
        if "8" in happenings:
            c lipbite mismatched sideeye "...Впрочем, она толком и не ест при мне."

    if u_pts >= 2 and d_pts <= 2:
        c closed1 smile1 neutral "И всё же... Это была чудесная ночь."
        show cassidy open
        "Каждый дорогой ей момент был высечен на сердце Кэссиди."

    show cassidy closed2 sad unhappyopen2 with dis
    "Она зевнула и медленно вылезла из кровати."
    show cassidy open neutral worried with dis
    "С Элоўэн или без, ей надо было заниматься ежедневными делами."



    if "7" in happenings and u_pts < 2:
        stop music fadeout 2
        jump bad_end5


    c closed1 smile2 "Хм-хммм м-м хм-хммм ммм~"
    show cassidy smile1 neutral
    "Кэссиди напевала любимую мелодию, пока убиралась и готовила завтрак."


    "Сидя за столом и запивая чаем булочку, она посмотрела на письменный набор, лежащий на столе рядом с вазой."
    show cassidy sideeye worried

    menu:
        c_choice "Многое произошло за это время... Может, пора написать Александру ещё одно письмо?"
        with ctransition
        "Да.":
            $ d_pts += 1
            c neutral smile2 closed1 "Очень важно держать моего брата в кусре того, что со мной происходит."
            show cassidy smile1 with dis
            "Закончив приём пищи, Кэссиди принялась писать Александру новое письмо."
            show cassidy frown down with dis
            "Но сердце её не особо лежало к этому. И письмо выходило довольно нескладным."
        "Нет.":
            $ d_pts -= 1
            show cassidy closed1 worried lowered with dis
            "Кэссиди помотала головой."
            if u_pts >= 2:
                c open unhappyopen "Это может подождать. Сейчас меня больше волнует, что там сейчас у Элоўэн..."
                show cassidy worried with dis
            else:
                c open unhappyopen "Это может подождать. Мне сложно сконцентрироваться на письме, когда тут непонятно что происходит с Элоўэн."
                show cassidy worried with dis
                "Её волновало то, навестит ли Элоўэн её сегодня вновь."

            $ happenings.append("19")

    show cassidy open with dis
    "Хоть бывшая принцесса и была привыкшей к одиночеству, теперь жизнь ей казалась гораздо более скучной и пустой, когда рядом не было Элоўэн."
    show cassidy smile1 with dis
    "И теперь она едва ли могла сконцентрироваться на своих обычных делах."

    c raised happyopen "Кто бы мог подумать, что события считанных дней могут так изменить человека!"

    show cassidy catface sideeye with dis
    "Между делом взгляд Кэссиди пал на окно."
    "Глубоко в лесу стояла её любимая вистерия."

    show cassidy closed1 lowered with dis
    menu:
        choice "Она так отчётливо видела вистерию у себя в голове."
        with ctransition
        "Элоўэн так похожа на это дерево.":
            $ k_pts += 1
            c unhappyopen "Элоўэн так похожа на это дерево. Она даже сама об этом сказала."
            c down "Такая красивая, и не даёт выбросить себя из головы... И такая одинокая."
            show cassidy worried
            "То, что сказала Элоўэн прошлой ночью, сильно повлияло на Кэссиди."
            $ happenings.append("20")
        "Интересно, там ли она сейчас.":

            c sideeye smile1 "Она сейчас, должно быть, где-то там, в лесу...."



    "День Кэссиди прошёл без происшествий, но на душе у неё было неспокойно."

    jump day7

label day7:

    $ save_name = "День седьмой"

    scene sky evening orange
    show evening
    with Dissolve(2)
    with Pause(0.3)
    scene sky night clear
    show night
    with Dissolve(2)
    with Pause(0.3)
    scene sky
    show daytime
    with Dissolve(2)
    with Pause(0.3)
    scene exteriorhouse with Dissolve(2)
    scene room with Dissolve(2)

    play music "sound/solace.ogg"

    "Наступило новое утро, а Элоўэн всё ещё не было. Кэссиди была наедине со своими мыслями."
    "...И мысли {i}об Элоўэн{/i} очень сильно беспокоили её. За последние несколько дней Элоўэн словно шипами впилась в жизнь Кэссиди."
    show cassidy lowered blush at top:
        zoom 0.7
        yoffset -100
    with dissolve

    c "Никогда не думала, что смогу ещё к кому-то привязаться."

    show cassidy none
    "Она думала об Элоўэн, о том, что та говорила, и о проведённом вместе времени, которого было так мало, но в то же время так много..."

    if "2b" in happenings:
        c mismatched down unhappyopen "Я так и не спросила у её про её ноги... Почему она постоянно подгибает пальцы?"
    c closed1 unhappyopen "Несмотря на внешность, она должна быть заметно старше меня. У неё такой тон общения, и она постоянно говорит, что уже давно живёт в этом лесу."
    c sideeye lipbite "И её мудрёная одежда, и её манеры..."
    show cassidy worried sad with dis
    "Что-то здесь не складывается."
    if "2" in happenings or "4" in happenings or "17" in happenings:
        show cassidy down with dis
        "Не похоже, чтобы Элоўэн сильно нравилось общаться с людьми.Очевидно, что очень мало кто знал о её пребывании в лесу, сколь долгим оно бы ни было."
        show black behind cassidy:
            alpha 0.5
        show cassidy glow
        with dissolve
        c_t sideeye sweatdrop pout lowered "Александр бы меня не отправил жить сюда, если бы ему было известно, что здесь живёт столь красивая дама."
        hide black
        show cassidy normal down sad worried
        with dissolve
        "Откуда она здесь? Почему она одна? У Кэссиди всё ещё не было ответов на эти вопросы."
    if "8" in happenings:
        "И самое странное..."
        c unhappyopen "Я всё ещё не видела, чтобы она что-либо ела."
        show cassidy worried with dis

    play music "sound/troubleinparadise.ogg" fadein 2 fadeout 2

    menu:
        choice "И если так подумать..."
        with ctransition
        "«Элоўэн довольно странная».":
            show black behind cassidy:
                alpha 0.5
            show cassidy glow
            with dissolve
            c_t closed1 "Она довольно странная. Впрочем, опять же, моя ситуация тоже не очень уж обыденная."
            c_t open lowered "Так что это всего лишь говорит о том, что мне предстоит ещё многое узнать о ней."
            hide black
            show cassidy normal
            with dissolve
        "«Элоўэн... не человек».":
            $ k_pts += 1
            show cassidy sweat sad closed1 with dis
            "Кэссиди внезапно поняла, что всё то, что она знает об Элоўэн, указывает ей на нечто по-настоящему ужасное."
            show cassidy down with dis
            "Она была так охвачена особым шармом и красотой Элоўэн, что явно упустила в ней нечто важное."
            $ happenings.append("21")

    show cassidy closed1 frown lowered none with dis
    "Кэссиди потрясла головой."
    if "21" in happenings:
        "Возможно, Кэссиди слишком торопилась с выводами."

        c neutral unhappyopen open "Должно быть, мне просто слишком одиноко. Я всё ещё не видела её после той ночи..."
    else:
        "Пускай Элоўэн и была несколько странной, Кэссиди знала, что в ней есть что-то ещё."
        show cassidy sideeye lipbite with dis
        "...Разве нет?"

    if "1" in happenings:
        c unhappyopen neutral "Она всегда была честна со мной. Даже если есть что-то, что она не может раскрыть предо мной..."
        show cassidy worried with dis

    if "3" in happenings:
        c closed1 smile2 "Она способна шутить, пусть и нечасто это делает. И её улыбка просто бесценна."
        show cassidy smile1 with dis

    if "4" in happenings and "10" in happenings:
        show cassidy narrowed2 frown fierce with dis
        "И всё же, в голове принцессы в этот момент всплыли менее приятные воспоминания."
        "Но хоть Элоўэн и красива, она всё же бывает слишком прямой. Бесчувственной. {i}Ужасной{/i}."
    else:
        c sideeye unhappyopen lowered "Но хоть она и бывает... грубой, возможно, но она это говорит из хороших побуждений."
        show cassidy worried

    if "12" in happenings and "13" in happenings and "15" in happenings and "16" in happenings and "18" in happenings:
        c sideeye blush smile2 lowered "Я... беспокоюсь за неё очень сильно. А она..."

        $ happenings.append("22")

    menu:
        choice "Возвращаясь к событиям последних дней..."
        with ctransition
        "«Элоўэн... заботится обо мне»." if "22" in happenings:
            $ u_pts += 1
        "«Элоўэн добра»." if u_pts >= k_pts and u_pts >= 3:
            $ u_pts += 1
        "«.........»":
            pass
        "«Элоўэн... воистину ужасна».":
            $ u_pts -= 2
            $ happenings.append("23")

    stop music fadeout 1

    if not "6" in happenings:
        play sound "sound/knock.ogg"
        show cassidy wide raised frown none with dis
        "Но вот, раздался стук в дверь, отвлекший Кэссиди от её глубоких размышлений. Стук был коротким. Это был сигнал, что пришло просто письмо, а не целая посылка."
        c unhappyopen "Письмо? Так скоро после предыдущего?"

        if not "19" in happenings:

            c "Я только вчера отправила брату письмо, он не мог так быстро прочитать его и уже ответить."
            c lipbite "...Верно ведь?"

        if "7" in happenings:
            c blush happyopen2 "Как я рада, что он так быстро ответил!"
        elif "5" in happenings:
            c happyopen "Может, мой брат наконец понял, как сильно я скучаю по нему."
        else:

            show cassidy lipbite sideeye with dis
            "Мысли о письме вытеснили из головы Кэссиди её прошлые думы."

    elif not "19" in happenings:
        show cassidy open pout lowered with dis
        "Кэссиди подумала о том письме, которое лишь вчера отправила Александру."
        if "21" in happenings or "23" in happenings:
            c unhappyopen down "Надо будет написать побольше об Элоўэн. Может, он посоветует что-нибудь на её счёт."
            c sideeye "...Или он разозлится, что я {i}опять{/i} завожу отношения с женщиной?"
            show cassidy worried with dis


    elif "19" in happenings:
        show cassidy down worried lowered with dis
        "Взгляд Кэссиди упал на её последний черновик письма, который лежал на столе."
        "Она начала писать его позапрошлым вечером."
        "После этого её мысли переключились на брата."
    else:

        show cassidy closed unhappyopen neutral with dis
        "Кэссиди вздохнула. Поток мыслей в её голове был нескончаем."
        show cassidy down worried with dis
        "Её взгляд упал на всё ещё недоразобранный ящик, стоящий на полу в кухне. При виде его, она подумала о своём брате."



    show black behind cassidy:
        alpha 0.5
    show cassidy glow
    with dissolve

    c_t down worried none "Если я отсюда уеду... Если Александр когда-нибудь позволит мне отсюда уехать... Что будет ждать меня?"

    if d_pts <= -1 and "11" in happenings:


        c_t "Выйти замуж... Замуж..."

        scene black with Dissolve(1)

        c fierce narrowed2 "...Он же прекрасно знает, что я этого не вынесу!"

        scene sky with Dissolve(1)

        "У неё в голове медленно начал открываться ларец с когда-то запертыми воспоминаниями..."

        $ happenings.append("24")












        play music "sound/memory.ogg"

        scene black with Dissolve(2)

        window hide None
        poem "{w=0.5}Однажды в королевстве Веромир родилась пара близнецов." with Dissolve(0.5)
        poem "Неожиданностью оказалась двойня. Сестра, что родилась минутами раньше, была объявлена наследницей престола. Все ожидали обиды и зависти со стороны её младшего брата, но ничего подобного не было."
        poem "Александр всячески поддерживал Кэссиди. Почти всё время они проводили вместе. Кроме брата, Кэссиди проводила время только со своими служанками, которые были отобраны из знатных семей."
        nvl clear
        poem "По мере того, как Кэссиди взрослела, становилось всё понятнее, что править она не сможет. Её мало интересовала политика. Ей больше нравилось общаться и проводить время с близкими друзьями."
        poem "Брат и сестра заключили договор, что когда она станет королевой, Александр будет править в качестве регента. Она не могла отречься от престола, чтобы королевство не выглядело слабым в глазах других стран, но в качестве правителя она во всём уступала своему брату."
        poem "Они дали друг другу слово, что будет так."
        nvl clear
        poem "Чтобы подготовиться к своей роли в качестве регента, Александр уехал учиться за границу. Ему пришлось умолять об этом короля и королеву, но в итоге они всё же разрешили ему поехать."
        poem "Хоть он и отсутствовал лишь несколько месяцев, Кэссиди было трудно без него. Она писала ему каждый день, и он с радостью отвечал ей."
        poem "Но время шло... и она писала ему всё реже и реже."
        poem "Он думал, что сестра отвлечена разговорами в компании своих служанок. Всё было в порядке."
        nvl clear
        poem "И вот, Александр решил сделать своей сестре сюрприз: приехать на праздники домой. Ведь он так долго её не видел, и она, должно быть, тоже скучала по нему."
        poem "Представьте себе его удивление..."
        poem "Или, скорее, настоящий ужас..."
        poem "Когда любящий брат обнаружил свою сестру в постели с другой женщиной!"
        nvl clear
        poem "Ту служанку немедленно отправили в ссылку. А Александр никогда никому не говорил о произошедшем. Он дорожил репутацией своей сестры. И своей собственной."
        poem "«Тебе было так одиноко, да?» — спросил он."
        poem "«Да... Невообразимо одиноко... А она была так добра ко мне...»"
        poem "Александр тут же прекратил своё заграничное обучение."
        poem "Они вновь каждый день стали проводить вместе."
        nvl clear
        poem "И всё же, трудно было игнорировать склонности принцессы. Кокетливый взгляд на служанку здесь, чувственное прикосновение там."
        poem "И брат, как бы ни хотел этого, не мог проводить с ней каждую минуту."
        poem "И когда их родители обсуждали политические свадьбы и обязанности близнецов, Александра переполнял страх."

        poem "«Мне?.. Жениться?.. Когда моя старшая сестра может отбить у меня жену?»"
        poem "И ещё страшнее ему было думать о том, чтобы её выдать за кого-либо замуж. За мужчину, который бы стал королём."
        nvl clear
        poem "Тем временем, всё больше служанок были втихую отправлены в ссылку."
        poem "И когда Александр уже был на грани сумасшествия, случилось немыслимое."

        poem "Отец близнецов, король... упал замертво прямо за ужином."

        poem "Старшая сестра, погрязшая в похоти, должна была стать королевой."
        poem "Впрочем, это не было целиком её виной — женщины сами летели к ней, как мотыльки на огонь. В то же время ей было очень одиноко, и помогал ей только постоянный контакт."
        poem "И она любила их всех... Всех, кроме своего брата!"
        poem "И она должна была стать королевой!"

        nvl clear

        poem "И вот, Кэссиди вдруг вызвали предстать перед парламентом. Их решение было быстрым и твёрдым: резолюция порицания."

        poem "«Почему?»"

        poem "«Кэссиди, принцесса Веромира... Вы обвиняетесь в совершении противонравственных действий!»"

        poem "Когда она услышала подробности того, в чём её обвиняют, её кровь ушла в пятки."
        poem "Александр им ни о чём не рассказывал — в этом она была уверена. Но с каждой следующей выгоняемой со двора служанкой, слухи всё росли. А принц молодой, горячий. Ни у кого не было сомнений в происходящем."
        nvl clear
        poem "Заделать ребёнка вне брака... Какой скандал!"
        poem "Никто ведь не знал, что ни одна из служанок не была беременна. Все они были высланы в сёла на неопределённый период — по сути, навсегда."
        poem "Никто, кроме близнецов, не знал правды."
        poem "Но... Откуда тогда парламенту стало известно?"

        poem "«Вы отрицаете это?»"
        poem "«Вы можете отрицать правоту выдвинутых обвинений?»"
        nvl clear
        poem "«Вам слово, джентельмен»."
        poem "Все глаза пали на принца. Конечно же, как тот, чьё достоинство непосредственно страдало от гулявших слухов, он больше всех был заинтересован в том, чтобы избавиться от Кэссиди."
        poem "Наказанием за совершённые ей деяния была смертная казнь."
        poem "Но принц предложил иное наказание."
        poem "Ссылка. В лес, за много миль от замка."
        poem "Бес попутал принцессу, оступилась, что же теперь, сразу на плаху? Не могли же все парламентарии быть столь бессердечны."
        nvl clear
        poem "Парламент был возмущён."

        poem "Но слова будущего короля имели своё влияние. Не вся королевская харизматичность передалась от родителей его старшей сестре."

        poem "И вот, решение было принято."

        poem "Кэссиди долго рыдала. Её любимый брат, у которого были все причины осуждать и презирать её... Спас ей жизнь."



        nvl clear

        postnvl "{nw}"

        scene room
        show cassidy at top:
            zoom 0.7
            yoffset -100
        with Dissolve(1)

        "Конечно же, Кэссиди не знала об истинных намерениях своего брата. Но нет никакого смысла держать их в секрете от {i}вас{/i}..."

    if "9" in happenings:
        if "24" in happenings:
            show black behind cassidy:
                alpha 0.5
            show cassidy glow
            with dissolve
        c_t closed1 frown lowered "Ссылка, конечно же, лучше казни."

    if "9" in happenings and not "4" in happenings:
        c_t lipbite sideeye lowered "И всё же, наверное, Элоўэн была права в своём отношении к Александру."
    elif "9" in happenings:
        c_t worried sideeye sad "Наверное, Элоўэн всё же была права в своём отношении к Александру."
    else:

        hide black
        show cassidy normal down
        with dissolve
        c unhappyopen "...Действительно ли политический брак — мой единственный способ выйти на свободу?"
        show black behind cassidy:
            alpha 0.5
        show cassidy glow frown sad
        with dissolve
        c_t "Если я ещё могу как-то послужить королевству... Будет ли это лучше? Перестанет ли моя жизнь быть бессмысленной?"

    menu:
        c_t_choice "Александр..."
        with ctransition
        "Как долго мне ещё тут находиться?" if d_pts >= 2:
            $ d_pts -= 1
            c_t sad worried down "Как долго мне ещё сидеть в этом лесу?"
            if "24" in happenings:
                c_t "Как долго я ещё буду сидеть в этой тюрьме?"
                c_t fierce narrowed frown "И всё это из-за... из-за меня. Из-за того, какая я, и с чем я ничего не могу поделать!"
            else:
                c_t frown "Останусь ли я навечно здесь... искупать свои грехи?"

            hide black
            show cassidy normal
            with dissolve

        "Любил ли ты меня на самом деле?" if d_pts < 2:
            $ d_pts -= 2
            c_t down worried sad "Александр... Правда ли ты любил меня?"
            c_t "Остался ли в тебе ещё тот дорогой мне младший брат, которого я когда-то знала?"
            c_t narrowed "Правда ли {i}ты{/i} писал мне все эти письма?"
            hide black
            show cassidy normal
            with dissolve
            "Одна негативная мысль породила дюжины."
            $ happenings.append("25")
        "Я буду верить в тебя и ждать.":

            $ d_pts += 2
            hide black
            show cassidy normal closed1 worried
            with dissolve
            "Скорее всего, она знала правду. Но боялась принять её."
            show cassidy down
            "Без своей любви к брату, без своей верности королевству... Она была ничем."
            c unhappyopen "Александр... Я верю, что ты сделаешь то, что лучше для меня и для Веромира. Я буду... Я буду ждать твоего решения."
            show cassidy worried sideeye
            "Она не могла не думать Элоўэн, но при этом испытывала болезненное чувство вины."
            $ happenings.append("26")

    show cassidy closed1 unhappyopen lowered with dis
    "Она глубоко вздохнула."
    show cassidy down frown with dis
    "Её мысли привели её в довольно нерадостное состояние."
    c unhappyopen "Если я продолжу думать об этом, то буду накручивать себя бесконечно."

    hide cassidy with dissolve

    "Она сделала себе чашечку чая, чтобы успокоить нервы, и принялась читать новую книгу."
    "Время от времени она несколько встревоженно поглядывала в окно."

    scene sky evening orange with fadeup

    "И вот, наступил вечер."

    jump end_check


label end_check:

    if "21" in happenings or "23" in happenings:

        if not "6" in happenings:
            jump bad_end3
        elif not "19" in happenings:
            jump bad_end3
        elif "7" in happenings:
            jump bad_end3
        else:
            jump bad_end1

    if d_pts >= 4:
        if not "6" in happenings:
            jump bad_end4
        elif not "19" in happenings:
            jump bad_end4
        elif "7" in happenings:
            jump bad_end4

    if "26" not in happenings and "22" in happenings:

        if d_pts <= 0 or "25" in happenings:

            jump good_end1

        elif d_pts >= 1 and d_pts <= 3:

            jump good_end2

    if k_pts >= 2 and d_pts >= u_pts:

        if not "6" in happenings:
            jump bad_end3
        elif not "19" in happenings:
            jump bad_end3
        elif "7" in happenings:
            jump bad_end3

        pass

    $ diff_pt = k_pts - u_pts

    if diff_pt >= 2 or diff_pt <= -2:
        jump bad_end1
    elif d_pts >= k_pts and d_pts >= u_pts:
        jump bad_end2
    else:
        jump bad_end6


label beta_text:

    $ percent()

    $ runseconds = renpy.get_game_runtime()
    $ runmin = 0.0
    $ runmin = runseconds/60

    poem "Привет! Тобой открыто [persistent.endcount] из 8 концовок, и прочитано [result1]%% текста игры ([result2]%% из которых — за данное прохождение)."
    poem "За данное прохождение тобою набрано [u_pts] очков понимания, [k_pts] очков знания и [d_pts] очков заблуждения. Какие-либо «происшествия» происходили с тобой [happenings] раз."
    poem "Тобой было потрачено [runmin] минут на прохождение игры."
    poem "Пожалуйста, сделай снимок этого экрана и поделись с нами, какая концовка выпала тебе! Спасибо за игру и надеюсь, что скоро мы снова встретимся!"


    return
# Decompiled by unrpyc: https://github.com/CensoredUsername/unrpyc
