init offset = -1










style default:
    font gui.default_font
    size gui.text_size
    color gui.text_color

style input:
    color gui.accent_color

style hyperlink_text:
    font gui.interface_font
    color gui.accent_color
    hover_color gui.hover_color
    hover_underline True


style gui_text:
    font gui.interface_font
    color gui.interface_text_color
    size gui.interface_text_size


style button:
    properties gui.button_properties("button")

style button_text is gui_text:
    properties gui.button_text_properties("button")
    yalign 0.5


style label_text is gui_text:
    color gui.accent_color
    size gui.label_text_size

style prompt_text is gui_text:
    color gui.text_color
    size gui.interface_text_size


style bar:
    ysize gui.bar_size
    left_bar "gui/slider/bar_full.png"
    right_bar "gui/slider/bar_empty.png"
    xmaximum 488
    idle_thumb "gui/slider/thumb.png"
    hover_thumb "gui/slider/thumb_hover.png"
    thumb_offset 13

style vbar:
    xsize gui.bar_size
    top_bar Frame("gui/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    ysize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb "gui/scrollbar/horizontal_[prefix_]thumb.png"


style vscrollbar:
    xsize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb "gui/scrollbar/vertical_[prefix_]thumb.png"
    unscrollable "hide"


style slider:
    ysize gui.slider_size
    base_bar Frame("gui/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/slider/horizontal_[prefix_]thumb.png"

style vslider:
    xsize gui.slider_size
    base_bar Frame("gui/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/slider/vertical_[prefix_]thumb.png"


style frame:
    padding gui.frame_borders.padding
    background Frame("gui/frame.png", gui.frame_borders, tile=gui.frame_tile)







transform fake_alpha:
    on show:
        alpha 1
        linear 0.5 alpha 0.5
    on hide:
        linear 0.5 alpha 1
        alpha 0

transform fadebox:
    on show:
        alpha 0
        linear 0.5 alpha 1
    on replace:
        alpha 0
        linear 0.5 alpha 1
    on hide:
        linear 0.5 alpha 0
    on replaced:
        linear 0.5 alpha 0

transform fake_alpha0:
    on show:
        alpha 0
        linear 0.5 alpha 1
    on hide:
        linear 0.5 alpha 0

transform lettert:
    on show:
        alpha 0
        linear 1 alpha 1
    on hide:
        linear 1 alpha 0

screen fake_cassidy:

    if fake_c_text != "":
        window:
            id "window"
            if hide_alpha == 1:
                at fake_alpha
            else:
                at fadebox
            background Frame("gui/cassidybox_50 copy.png", top=41, bottom=41)

            left_padding 30
            right_padding 200
            top_padding 50
            bottom_padding 50
            yminimum 200
            xsize 833

            yalign 0.8
            xalign 0.9
            yoffset 30
            xfill True


            window:
                xalign 0.5 yalign 0.5
                text fake_c_text + "{image=fake_ctc}" xalign 0.0 yalign 0.5 xsize 510 line_spacing -5 text_align 0.5 layout "subtitle" style "say_dialogue"

                id "nbox"
            foreground "cassidyname"
    else:
        null
image fake_ctc:
    "gui/petal2.png"
    alpha 0.0
screen fake_elowen:


    if fake_e_text != "":

        window:
            id "window"

            if hide_alpha == 1:
                at fake_alpha
            else:
                at fadebox

            background Frame("gui/elowenbox_50 copy.png", top=41, bottom=41)



            if met_elowen:
                left_padding 170
                right_padding 45
            else:
                left_padding 0
                right_padding 0
            top_padding 50
            bottom_padding 50
            yminimum 200
            xsize 833
            yalign 0.7
            xalign 0.1
            xfill True

            window:
                xalign 0.5 yalign 0.5
                if met_elowen:
                    text fake_e_text+ "{image=fake_ctc}" xalign 0.0 yalign 0.5 xsize 520 line_spacing -5 text_align 0.5 layout "subtitle" style "say_dialogue"
                else:
                    text fake_e_text+ "{image=fake_ctc}" xalign 0.0 yalign 0.5 xsize 573 line_spacing -5 text_align 0.5 layout "subtitle" style "say_dialogue"
                id "nbox"
            if met_elowen:
                foreground "elowenname"
    else:
        null

screen letter:

    add "paper" at lettert
    text letter_text xpos 671 ypos 177 xanchor 0.0 yanchor 0.0 style "say_dialogue" layout "tex" text_align 0.0 color "#36293C" xsize 620 at lettert














screen say(who, what, namebox_type=None):
    tag say
    style_prefix "say"
    window:

        id "window"
        window:
            xalign 0.5 yalign 0.5

            text what id "what"
            id "nbox"
        if namebox_type is not None:
            foreground namebox_type



    on "show" action With(Dissolve(0.5))
    on "hide" action With(Dissolve(0.5))


style window is default
style say_label is default



style namebox is default
style namebox_label is say_label


















style namebox:
    xpos gui.name_xpos
    xanchor gui.name_xalign

    ypos gui.name_ypos



    padding gui.namebox_borders.padding

style say_label:
    color gui.accent_color
    font gui.name_font
    size gui.name_text_size
    xalign gui.name_xalign
    yalign 0.5

style say_dialogue:
    xpos gui.text_xpos
    xanchor gui.text_xalign

    line_spacing -5
    font gui.default_font
    size gui.text_size
    text_align gui.text_xalign
    layout ("subtitle" if gui.text_xalign else "tex")

style say_thought is say_dialogue











screen input(prompt):
    style_prefix "input"

    window:

        has vbox:
            xpos gui.text_xpos
            xanchor gui.text_xalign
            ypos gui.text_ypos

        text prompt style "input_prompt"
        input id "input"


style input_prompt is default

style input_prompt:
    xmaximum gui.text_width
    xalign gui.text_xalign
    text_align gui.text_xalign

style input:
    xmaximum gui.text_width
    xalign gui.text_xalign
    text_align gui.text_xalign









transform choicetransition:

    on show:
        linear 1 alpha 1
    on replace:

        linear 1 alpha 1

transform chosen:
    on show:
        parallel:
            linear 1 zoom 1.5
        parallel:
            linear 1 alpha 0
default choice_path = []
screen show_choices():
    vbox:
        for i in choice_path:
            frame:
                text i
screen choice(items):
    style_prefix "choice"

    vbox:
        at choicetransition
        for i in items:
            if i.chosen:
                textbutton i.caption action i.action,AddToSet(choice_path,i.caption) activate_sound "sound/thump.ogg" hover_foreground Transform("yellow_petal_anim",xpos=813,yalign=0.5,yoffset=-5)
            else:
                textbutton i.caption action i.action,AddToSet(choice_path,i.caption) activate_sound "sound/thump.ogg" hover_foreground Transform("white_petal_anim",xpos=813,yalign=0.5,yoffset=-5)

screen chosen:

    vbox:
        xalign 0.5
        yalign 0.85
        yanchor 0.5
        at chosen

        textbutton chosen_text action NullAction() style "choice_button" idle_background "gui/choice_active.png"


screen chosen2:

    vbox:
        xalign 0.5
        yalign 0.85
        yanchor 0.5
        at chosen

        null height 70
        textbutton chosen_text action NullAction() style "choice_button" idle_background "gui/choice_active.png"




define config.narrator_menu = True

style choice_vbox is vbox
style choice_button is button
style choice_button_text is button_text

style choice_vbox:
    xalign 0.5
    yalign 0.85
    yanchor 0.5

    spacing gui.choice_spacing

style choice_button is default:

    properties gui.button_properties("choice_button")

style choice_button_text is default:
    properties gui.button_text_properties("choice_button")

style choice_button:
    hover_background "gui/choice_active.png"
    idle_background "gui/choice_inactive.png"
    xsize 863
    ysize 70

style choice_button_text:
    font gui.default_font
    size gui.text_size
    yalign 0.5
































screen quick_menu():


    zorder 100



    imagebutton idle "gui/quickmenu/ribbon_idle.png" hover "gui/quickmenu/ribbon_hover.png" xalign 0.995 yalign 0.0 focus_mask True action [ Show("quick_menu_open", transition=dissolve), Hide("quick_menu", transition=dissolve) ]

screen quick_menu_open():

    zorder 100

    add "gui/quickmenu/quickmenu_base.png" xalign 1.0 yalign 0.0
    imagebutton idle "gui/quickmenu/ribbon_idle.png" hover "gui/quickmenu/ribbon_hover.png" xalign 0.995 yalign 0.0 focus_mask True action [ Show("quick_menu", transition=dissolve), Hide("quick_menu_open", transition=dissolve) ]

    hbox:
        style_prefix "quick"

        xalign 0.925
        yalign 0.005


        textbutton _("Перемотка") action Skip() alternate Skip(fast=True, confirm=True)
        textbutton _("Автопроигрывание") action Preference("auto-forward", "toggle")
        textbutton _("История") action [ ScrollToBottom(), ShowMenu('history') ]
        textbutton _("Сохранить") action ShowMenu('save')
        textbutton _("Загрузить") action ShowMenu('load')


        textbutton _("Настройки") action ShowMenu('preferences')

style quick_button is default
style quick_button_text is button_text

style quick_button:
    properties gui.button_properties("quick_button")

style quick_button_text:
    properties gui.button_text_properties("quick_button")










screen navigation():

    if main_menu:
        imagemap:
            alpha True
            auto "gui/imagemaps/navbarmm_%s.png"
            hotspot (702, 305, 132, 60) action Return()
            hotspot (846, 305, 212, 63) action ShowMenu("load")
            hotspot (1071, 305, 228, 63) action ShowMenu("preferences")
            hotspot (1310, 305, 150, 63) action ShowMenu("extras"),SelectedIf(renpy.get_screen(["extras","extras_music","extras_gallery","extras_endings","extras_characters","extras_about_l3","extras_artbook","translation_ru"]))
            hotspot (1473, 305, 179, 60) action ShowMenu("help")
            hotspot (1665, 305, 141, 60) action Quit(confirm=not main_menu)

    else:
        imagemap:
            alpha False
            auto "gui/imagemaps/navbar_%s.png"

            hotspot (468, 306, 131, 58) action Return()
            hotspot (604, 306, 179, 62) action ShowMenu("history")
            hotspot (788, 306, 121, 62) action ShowMenu("save")
            hotspot (915, 306, 111, 62) action ShowMenu("load")
            hotspot (1032, 306, 225, 62) action ShowMenu("preferences")
            hotspot (1263, 306, 176, 58) action ShowMenu("help")
            hotspot (1445, 306, 216, 58) action MainMenu()
            hotspot (1665, 306, 140, 58) action Quit(confirm=not main_menu)






style navigation_button is gui_button
style navigation_button_text is gui_button_text

style navigation_button:
    size_group "navigation"
    properties gui.button_properties("navigation_button")

style navigation_button_text:
    properties gui.button_text_properties("navigation_button")







default persistent.custom_mm = 0
image sleepover_mm = Transform("sleepover",zoom=0.675)
image ogkv_mm = Transform("ogkv",zoom=0.785,yalign=0.65)
define easter_egg_mm = {
    0 : "",
    1 : "sleepover_mm",
    2 : "first meeting1",
    3 : "ogkv_mm",
    4 : "kv",
    5 : "romance",
    6 : "exteriorhouse"
}
image empty_bg = Fixed(xsize=1920,ysize=1080)
init python:
    def cycle_mm_bg():
        if persistent.promos_unlocked:
            persistent.custom_mm += 1
            if persistent.custom_mm >= 7:
                persistent.custom_mm = 0
screen main_menu():
    tag menu




    style_prefix "main_menu"





    imagemap:
        add gui.main_menu_background
        ground "empty_bg"
        alpha False
        if persistent.custom_mm != 0:
            add easter_egg_mm[persistent.custom_mm]
        add "gui/titlescreen/mm_button_ground.png"
        hotspot (354, 369, 87, 103) action Function(cycle_mm_bg)
        add "gui/titlescreen/mm_logo.png"

    imagebutton idle "gui/titlescreen/start_idle.png" hover "gui/titlescreen/start_hover.png" xpos 387 ypos 515 focus_mask None action Start()
    imagebutton idle "gui/titlescreen/load_idle.png" hover "gui/titlescreen/load_hover.png" xpos 387 ypos 593 focus_mask None action ShowMenu("load")
    imagebutton idle "gui/titlescreen/options_idle.png" hover "gui/titlescreen/options_hover.png" xpos 387 ypos 674 focus_mask None action ShowMenu("preferences")
    imagebutton idle "gui/titlescreen/help_idle.png" hover "gui/titlescreen/help_hover.png" xpos 410 ypos 756 focus_mask None action ShowMenu("help")
    imagebutton idle "gui/titlescreen/extras_idle.png" hover "gui/titlescreen/extras_hover.png" xpos 410 ypos 834 focus_mask None action ShowMenu("extras")
    imagebutton idle "gui/titlescreen/exit_idle.png" hover "gui/titlescreen/exit_hover.png" xpos 410 ypos 914 focus_mask None action Quit(confirm=not main_menu)





style main_menu_frame is empty
style main_menu_vbox is vbox
style main_menu_text is gui_text
style main_menu_title is main_menu_text
style main_menu_version is main_menu_text

style main_menu_button_text:
    size 50

style main_menu_frame:
    xsize 420
    yfill True

    background "gui/overlay/main_menu.png"

style main_menu_vbox:
    xalign 1.0
    xoffset -30
    xmaximum 1200
    yalign 1.0
    yoffset -30

style main_menu_text:
    xalign 1.0

    layout "subtitle"
    text_align 1.0
    color gui.accent_color

style main_menu_title:
    size gui.title_text_size











screen game_menu(title, scroll=None):


    if main_menu:
        add gui.main_menu_background
    else:
        add gui.game_menu_background

    style_prefix "game_menu"

    frame:
        style "game_menu_outer_frame"

        has hbox


        frame:
            style "game_menu_navigation_frame"

        frame:
            style "game_menu_content_frame"

            if scroll == "viewport":

                viewport:
                    scrollbars "vertical"
                    mousewheel True
                    draggable True

                    side_yfill True

                    has vbox
                    transclude

            elif scroll == "vpgrid":

                vpgrid:
                    cols 1
                    yinitial 1.0

                    scrollbars "vertical"
                    mousewheel True
                    draggable True

                    side_yfill True

                    transclude

            else:

                transclude

    use navigation


    if main_menu:
        key "game_menu" action ShowMenu("main_menu")


style game_menu_outer_frame is empty
style game_menu_navigation_frame is empty
style game_menu_content_frame is empty
style game_menu_viewport is gui_viewport
style game_menu_side is gui_side
style game_menu_scrollbar is gui_vscrollbar

style game_menu_label is gui_label
style game_menu_label_text is gui_label_text

style return_button is navigation_button
style return_button_text is navigation_button_text

style game_menu_outer_frame:
    bottom_padding 25
    top_padding 390

    background "gui/overlay/game_menu.png"

style game_menu_navigation_frame:
    xsize 0
    yfill True

style game_menu_content_frame:
    left_margin 100
    right_margin 150
    top_margin 15

style game_menu_viewport:
    xsize 1380

style game_menu_vscrollbar:
    unscrollable gui.unscrollable

style game_menu_side:
    spacing 15

style game_menu_label:
    xpos 75
    ysize 180

style game_menu_label_text:
    size gui.title_text_size
    color gui.accent_color
    yalign 0.5

style return_button:
    xpos gui.navigation_xpos
    yalign 1.0
    yoffset -45









screen extras():
    tag menu





    use extras_nav

    style_prefix "about"

    add "gui/about_viewport.png"

    viewport:
        area (854, 493, 762, 496)
        scrollbars "vertical"
        mousewheel True
        draggable True

        side_yfill True

        text "Without a Voice - это юри-вн, выпущенная командой инди-разработчиков L³. Команду L³ составляют сценарист/кодер {a=http://trash.moe/}Lore{/a}, художник Lani и редактор {a=http://waltz.moe/portfolio/}Laiska{/a}.\n\nИгру изначально планировалось подготовить к {a=https://itch.io/jam/yuri-game-jam-2016}Yuri Game Jam 2016{/a}, но разработка немного отстала от графика, и окончательно игра была готова лишь к 2020 году.\n\nОгромное спасибо за игру! Если вам не трудно, пожалуйста, поделитесь с нами своими впечатлениями от игры, написав нам в соцсетях или в комментариях на странице проекта в {a=https://l3.itch.io/wav}itch.io{/a}.\n\nЕсли вам интересно узнать больше об игре, то обратите внимание на наш артбук, доступный {a=https://store.steampowered.com/app/1262200/Without_A_Voice__Artbook/}в Steam{/a} и {a=https://l3.itch.io/wav}на странице игры на itch.io{/a}!\n\nМузыкальное сопровождение для Without a написал {a=https://www.patreon.com/ExPsyle}ExPsyle{/a}.\n\nМеню дополнительных материалов, анимация персонажей и некоторые другие ништяки были написаны {a=https://twitter.com/minutekiwi}minute{/a}.\n\nИздано Bellhouse - Studio Élan.\n\nСделано с любовью на {a=https://www.renpy.org/}Ren'Py{/a} v.[renpy.version_only].\n\n[renpy.license!t]"

    use about_nav
screen extras_characters():
    tag menu

    use extras_nav



    style_prefix "about"

    add AlphaMask(Solid("#100c13"), "gui/extras_mask.png")
    add "gui/extras_border.png"
    if persistent.endings:
        viewport:
            area (854, 493, 762, 496)
            scrollbars "vertical"
            mousewheel True
            draggable True
            has vbox:
                xpos 25
            if chara_choice == About_Elowen:
                text "Элоўэн" color "#fff" size 45 outlines [(absolute(3), "#382a3f", absolute(0), absolute(0))]
            else:
                text "Кэссиди" color "#fff" size 45 outlines [(absolute(3), "#382a3f", absolute(0), absolute(0))]
            text "[chara_choice]"

        use character_choice
    else:
        text "Загляните сюда после того, как пройдёте игру." color "#fff" size 45 outlines [(absolute(3), "#382a3f", absolute(0), absolute(0))]:
            at truecenter
screen extras_artbook():
    tag menu

    use extras_nav

    style_prefix "about"

    add "gui/about_viewport.png"

    viewport:
        area (854, 493, 762, 496)
        scrollbars "vertical"
        mousewheel True
        draggable True

        side_yfill True
        has vbox:
            xalign 0.5
        add "artbookpreview" xalign 0.5
        null height 15
        text "{b}Артбук Without a Voice{/b} содержит ранние наброски артов игры, комментарии создателей, и гайд по концовкам игры.\n\nПриобрести артбук можно в Steam или на {a=https://l3.itch.io/wav}itch.io{/a} (при оплате на сумму от $5).\n\nПоскольку сама игра совершенно бесплатна, мы будет безмерно благодарны вам, если вы поддержите нас, приобретя данный артбук."

    use about_nav

screen translation_ru():
    tag menu

    use extras_nav

    style_prefix "about"

    add "gui/about_viewport.png"

    viewport:
        area (854, 493, 762, 496)
        mousewheel True
        draggable True

        side_yfill True

        text "\nПеревод всего текста в игре и необходимые графические и программные правки в UI выполнил Hy60koshk.\n\nТестирование и вычитка: Ritorika.\n\nПосмотреть другие наши русификаторы можно на {a=https://koshk.ru/}koshk.ru{/a}."

    use about_nav

screen extras_about_l3():
    tag menu

    use extras_nav

    style_prefix "about"

    add "gui/about_viewport.png"

    viewport:
        area (854, 493, 762, 496)
        scrollbars "vertical"
        mousewheel True
        draggable True

        side_yfill True

        text "\nНаша команда состоит из писателя/программиста {a=http://trash.moe/}Lorelei{/a}, художника/дизайнера Laniessa, и писателя/редактора {a=http://waltz.moe/portfolio/}Laiska{/a}.\n\n{b}LANIESSA{/b}\n{a=https://twitter.com/adirosette}@adirosette{/a}\n\n{b}LAISKA{/b}\n{a=https://twitter.com/petitscygnes}@petitscygnes{/a}\n{a=http://waltz.moe/portfolio/}Portfolio{/a}\n\n{b}LORELEI{/b}\n{a=http://twitter.com/yandere}@yandere{/a}\n{a=http://trash.moe}Portfolio{/a}\n\nДля данной игры, Laniessa занималась всеми артами, дизайном UI и программированием некоторых менюшек. Lore придумала оригинальную идею, написала и запрограммировала диалоги. Laiska занималась тестирование и редактурой.\n\n"

    use about_nav

screen extras_about_credits():
    tag menu






    use extras_nav



    style_prefix "about"

    add "gui/about_viewport.png"

    viewport:
        area (854, 493, 762, 496)
        scrollbars "vertical"
        mousewheel True
        draggable True

        side_yfill True

        text "\nХудожник/дизайнер UI - Laniessa (aka Adirosa)\nСценарист/программист - Lorelei\nРедактор - Laiska\nКомпозитор - {a=https://www.patreon.com/ExPsyle}ExPsyle{/a}\n\nТакже огромное спасибо нашим друзьям, помогавшим с тестированием на ранних этапах: Ally Kaye, Kitty, Lily, и NooseyGoosey.\n\n"

    use about_nav

default endings_bg = "forest"


screen extras_endings():
    tag menu

    use extras_nav

    style_prefix "about"

    add AlphaMask("[endings_bg]", "gui/extras_mask.png")
    add AlphaMask(Solid("#000000B3"), "gui/extras_mask.png")
    add AlphaMask("gui/readability_overlay.png", "gui/extras_mask.png")
    add "gui/extras_border.png"

    vbox:

        xpos 350
        ypos 525

        textbutton "1. Ужин с любимыми" action SetVariable("endings_bg", "badend1"),SensitiveIf(1 in persistent.endings)
        textbutton "2. Пика о двух концах" action SetVariable("endings_bg", "badend2"),SensitiveIf(2 in persistent.endings)
        textbutton "3. Прах к праху" action SetVariable("endings_bg", "badend3b"),SensitiveIf(3 in persistent.endings)
        textbutton "4. Слишком поздно я паду в твои объятия" action SetVariable("endings_bg", "badend4"),SensitiveIf(4 in persistent.endings)
        textbutton "5. Сгустились тени" action SetVariable("endings_bg", "badend5"),SensitiveIf(5 in persistent.endings)
        textbutton "6. История без конца" action SetVariable("endings_bg", "black"),SensitiveIf(6 in persistent.endings)
        textbutton "7. Истинно свободные" action SetVariable("endings_bg", "goodend1"),SensitiveIf(7 in persistent.endings)
        textbutton "8. Вместе мы — бессмертны" action SetVariable("endings_bg", "goodend2"),SensitiveIf(8 in persistent.endings)

    viewport:
        area (854, 493, 762, 496)
        scrollbars "vertical"
        mousewheel True
        draggable True
        side_yfill True
        text "\n"+ending_dictionary[endings_bg]+"\n\n"



screen extras_music():
    tag menu

    use extras_nav

    style_prefix "music"






    add AlphaMask("forest", "gui/extras_mask.png")
    add AlphaMask("gui/readability_overlay.png", "gui/extras_mask.png")
    add "gui/extras_border.png"


    grid 3 6:

        transpose True

        xpos 255 ypos 506 xsize 1410 ysize 500 yfill True xfill True

        if mr.is_unlocked("sound/forest.ogg"):
            textbutton _("1. Сказочный лес") action mr.Play("sound/forest.ogg")
        else:
            textbutton _("1. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/madbox.ogg"):
            textbutton _("2. Вальс безумия") action mr.Play("sound/madbox.ogg")
        else:
            textbutton _("2. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/morning.ogg"):
            textbutton _("3. Первые лучи") action mr.Play("sound/morning.ogg")
        else:
            textbutton _("3. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/solace.ogg"):
            textbutton _("4. Утешение") action mr.Play("sound/solace.ogg")
        else:
            textbutton _("4. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/memory.ogg"):
            textbutton _("5. Память") action mr.Play("sound/memory.ogg")
        else:
            textbutton _("5. Не открыто") action NullAction(),SensitiveIf(None),SensitiveIf(None)

        if mr.is_unlocked("sound/wind.ogg"):
            textbutton _("6. Шёпот ветра") action mr.Play("sound/wind.ogg")
        else:
            textbutton _("6. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/moon.ogg"):
            textbutton _("7. Таинственная луна") action mr.Play("sound/moon.ogg")
        else:
            textbutton _("7. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/troubleinparadise.ogg"):
            textbutton _("8. Беда в Раю") action mr.Play("sound/troubleinparadise.ogg")
        else:
            textbutton _("8. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/silk.ogg"):
            textbutton _("9. Шёлковые нити") action mr.Play("sound/silk.ogg")
        else:
            textbutton _("9. Не открыто") action NullAction(),SensitiveIf(None)



        if mr.is_unlocked("sound/darkfate.ogg"):
            textbutton _("10. Мрачная участь") action mr.Play("sound/darkfate.ogg")
        else:
            textbutton _("10. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/madness.ogg"):
            textbutton _("11. Безумие") action mr.Play("sound/madness.ogg")
        else:
            textbutton _("11. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/madbox2.ogg"):
            textbutton _("12. Вальс безумия II") action mr.Play("sound/madbox2.ogg")
        else:
            textbutton _("12. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/resolution.ogg"):
            textbutton _("13. Решительность") action mr.Play("sound/resolution.ogg")
        else:
            textbutton _("13. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/faery.ogg"):
            textbutton _("14. Волшебство") action mr.Play("sound/faery.ogg")
        else:
            textbutton _("14. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/heartofdarkness.ogg"):
            textbutton _("15. Сердце тьмы") action mr.Play("sound/heartofdarkness.ogg")
        else:
            textbutton _("15. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/clumsy.ogg"):
            textbutton _("16. Неловкость") action mr.Play("sound/clumsy.ogg")
        else:
            textbutton _("16. Не открыто") action NullAction(),SensitiveIf(None)

        if mr.is_unlocked("sound/onceuponatime.ogg"):
            textbutton _("17. Давным-давно") action mr.Play("sound/onceuponatime.ogg")
        else:
            textbutton _("17. Не открыто") action NullAction(),SensitiveIf(None)

        null

style music_button_text is about_button_text



init python:


    mr = MusicRoom(fadeout=0.5)
    mr.add("sound/forest.ogg")
    mr.add("sound/madbox.ogg")
    mr.add("sound/morning.ogg")
    mr.add("sound/solace.ogg")
    mr.add("sound/memory.ogg")
    mr.add("sound/wind.ogg")
    mr.add("sound/moon.ogg")
    mr.add("sound/troubleinparadise.ogg")
    mr.add("sound/silk.ogg")
    mr.add("sound/darkfate.ogg")
    mr.add("sound/madness.ogg")
    mr.add("sound/madbox2.ogg")
    mr.add("sound/resolution.ogg")
    mr.add("sound/faery.ogg")
    mr.add("sound/heartofdarkness.ogg")
    mr.add("sound/clumsy.ogg")
    mr.add("sound/onceuponatime.ogg")

style about_button_text:

    size 42
    outlines [(absolute(3), "#100c13", absolute(0), absolute(0))]
    insensitive_color "#1c151a"
    idle_color "#ac9fa0"
    selected_color "#ffffff"
    hover_color "#ffffff"
    text_align 1.0
style about_viewport:

    top_padding 50
    bottom_padding 50
default chara_choice = About_Cassidy
screen character_choice:
    hbox:
        xpos 245 ypos 505
        spacing 15
        imagebutton auto "gui/button/elowen_%s.png" action SetVariable("chara_choice",About_Elowen)
        imagebutton auto "gui/button/cassidy_%s.png" action SetVariable("chara_choice",About_Cassidy)
screen about_nav:

    vbox:

        xpos 362
        ypos 623

        textbutton "L³" action ShowMenu("extras_about_l3")
        textbutton "Without a Voice" action ShowMenu("extras")
        textbutton "Артбук" action ShowMenu("extras_artbook")
        textbutton "Перевод" action ShowMenu("translation_ru")

#    add "gui/fakeabout.png"

screen extras_nav:

    if main_menu:
        add gui.main_menu_background
    else:
        add gui.game_menu_background

    style_prefix "game_menu"

    frame:
        style "game_menu_outer_frame"

        has hbox


        frame:
            style "game_menu_navigation_frame"

        frame:
            style "game_menu_content_frame"

            transclude

    if main_menu:
        key "game_menu" action ShowMenu("main_menu")

    add "gui/menulabels/extras.png"

    imagemap:
        alpha False
        auto "gui/imagemaps/extras_%s.png"

        hotspot (187, 395, 232, 62) action ShowMenu("extras_gallery")
        hotspot (512, 395, 201, 62) action ShowMenu("extras_music")
        hotspot (806, 395, 292, 62) action ShowMenu("extras_characters")
        hotspot (1190, 395, 255, 62) action ShowMenu("extras_endings")
        hotspot (1538, 395, 195, 62) action ShowMenu("extras")

    use navigation


    text "[done_percent]% прохождения" xalign 0.995 yalign 0.0 size 42 outlines [(absolute(3), "#100c13", absolute(0), absolute(0))]



define gui.about = ""


style about_label is gui_label
style about_label_text is gui_label_text
style about_text is gui_text

style about_label_text:
    size gui.label_text_size












screen save():
    tag menu


    use file_slots(_("Save"))
    add "gui/menulabels/save.png"


screen load():
    tag menu


    use file_slots(_("Load"))
    add "gui/menulabels/load.png"


screen file_slots(title):

    default page_name_value = FilePageNameInputValue()



    use game_menu(title):

        fixed:



            order_reverse True


            button:
                style "page_label"

                key_events True
                xalign 0.5
                yalign 0.05
                action page_name_value.Toggle()

                input:
                    style "page_label_text"
                    value page_name_value


            grid gui.file_slot_cols gui.file_slot_rows:
                style_prefix "slot"

                xalign 0.5
                yalign 0.3

                spacing gui.slot_spacing

                for i in range(gui.file_slot_cols * gui.file_slot_rows):

                    $ slot = i + 1

                    button:
                        action FileAction(slot)

                        has vbox



                        add AlphaMask(FileScreenshot(slot), "gui/alphamask.png") xalign 0.5

                        text FileTime(slot, format=_("{#file_time}%A, %B %d %Y, %H:%M"), empty=_("Пустой слот")):
                            style "slot_time_text"
                            yalign 1.0
                            xalign 0.5

                        text FileSaveName(slot):
                            style "slot_name_text"

                        key "save_delete" action FileDelete(slot)


            hbox:
                style_prefix "page"

                xalign 0.5
                yalign 0.80

                spacing gui.page_spacing

                textbutton _("<") action FilePagePrevious()

                textbutton _("{#auto_page}A") action FilePage("auto")

                textbutton _("{#quick_page}Q") action FilePage("quick")


                for page in range(1, 6):
                    textbutton "[page]" action FilePage(page)

                textbutton _(">") action FilePageNext()


style page_label is gui_label
style page_label_text is gui_label_text
style page_button is gui_button
style page_button_text is gui_button_text

style slot_button is gui_button
style slot_button_text is gui_button_text
style slot_time_text is slot_button_text
style slot_name_text is slot_button_text

style page_label:
    xpadding 75
    ypadding 5

style page_label_text:
    text_align 0.5
    layout "subtitle"
    idle_color "#ac9fa0"
    hover_color "#d4cdce"
    selected_color "#ffffff"
    outlines [ (absolute(3), "#403741", absolute(0), absolute(0)) ]
    size 35

style page_button:
    properties gui.button_properties("page_button")

style page_button_text:
    properties gui.button_text_properties("page_button")
    size 35
    idle_color "#ac9fa0"
    hover_color "#d4cdce"
    selected_color "#ffffff"
    outlines [ (absolute(3), "#403741", absolute(0), absolute(0)) ]

style slot_button:
    properties gui.button_properties("slot_button")

style slot_button_text:
    properties gui.button_text_properties("slot_button")
    size 28
    idle_color "#ac9fa0"
    hover_color "#ffffff"
    insensitive_color "#8f8c92"
    outlines [ (absolute(3), "#1d1623", absolute(0), absolute(0)) ]









screen preferences():
    tag menu

    use game_menu(_("Options"), scroll="viewport")





    imagebutton auto "gui/prefs/windowed_%s.png" xpos 184 ypos 484 focus_mask None action [Preference("display", "window"), SelectedIf(_preferences.fullscreen==False)] tooltip _("Отображать игру в окне.")
    imagebutton auto "gui/prefs/fullscreen_%s.png" xpos 455 ypos 484 focus_mask None action Preference("display", "fullscreen") tooltip _("Развернуть игру на весь экран.")

    imagebutton auto "gui/prefs/unseen_%s.png" xpos 400 ypos 720 focus_mask None action Preference("skip", "toggle") tooltip _("Если включено, то непрочтённый ранее текст будет пропускаться в режиме перемотки.")
    imagebutton auto "gui/prefs/after_%s.png" xpos 400 ypos 763 focus_mask None action Preference("after choices", "toggle") tooltip _("Если включено, то после выбора варианта действия будет возобновлён режим перемотки.")
    imagebutton auto "gui/prefs/transitions_%s.png" xpos 399 ypos 810 focus_mask None action InvertSelected(Preference("transitions", "toggle")) tooltip _("Если включено, то плавные переходы в игре будут отключены.")

    imagebutton auto "gui/prefs/rboff_%s.png" xpos 500 ypos 890 focus_mask None action Preference("rollback side", "disable") tooltip _("Отключить возврат назад по клику в окне.")
    imagebutton auto "gui/prefs/rbleft_%s.png" xpos 585 ypos 890 focus_mask None action Preference("rollback side", "left") tooltip _("Вы будете возвращаться назад по скрипту при клике на крайней левой части окна.")
    imagebutton auto "gui/prefs/rbright_%s.png" xpos 690 ypos 890 focus_mask None action Preference("rollback side", "right") tooltip _("Вы будете возвращаться назад по скрипту при клике на крайней правой части окна.")

    imagebutton auto "gui/prefs/vollkorn_%s.png" xpos 805 ypos 647 focus_mask None action gui.SetPreference("font", "Vollkorn-Regular.ttf", rebuild=True) tooltip _("В игре будет использоваться шрифт Vollkorn.")
    imagebutton auto "gui/prefs/opendyslexic_%s.png" xpos 950 ypos 649 focus_mask None action gui.SetPreference("font", "OpenDyslexic-Regular.otf", rebuild=True) tooltip _("В игре будет использоваться шрифт Open Dyslexic.")

    imagebutton auto "gui/prefs/default_%s.png" xpos 1160 ypos 646 focus_mask None action gui.SetPreference("size", 30, rebuild=True) tooltip _("Сделать шрифт такого размера, как задумал разработчик.")
    imagebutton auto "gui/prefs/large_%s.png" xpos 1306 ypos 643 focus_mask None action gui.SetPreference("size", 36, rebuild=True) tooltip _("Сделать шрифт побольше.")

    imagebutton auto "gui/prefs/white_%s.png" xpos 1494 ypos 648 focus_mask None action StylePreference("color", "white") tooltip _("Сделать цвет текста белым.")
    imagebutton auto "gui/prefs/offwhite_%s.png" xpos 1612 ypos 648 focus_mask None action StylePreference("color", "offwhite") tooltip _("Сделать цвет текста кремовым.")

    imagebutton auto "gui/prefs/mute_%s.png" xpos 1426 ypos 733 focus_mask None action Preference("all mute", "toggle") tooltip _("Выключить всю музыку и звуки.")

    bar pos (1230,459) value Preference("text speed") style "bar" tooltip _("Скорость появления строк на экране. Если выкрутить до упора, то текст будет появляться мгновенно.")
    bar pos (1230,521) value Preference("auto-forward time") style "bar" tooltip _("Задержка при автомат. перелистывании. Если выкрутить до упора, переключение реплик будет предельно медленным.")

    bar pos (1230,804) value Preference("music volume") style "bar" tooltip _("Громкость фоновой музыки.")
    bar pos (1230,866) value Preference("sound volume") style "bar" tooltip _("Громкость звуковых эффектов.")
    bar pos (1230,928) value Preference("mixer txt volume") style "bar" tooltip _("Громкость эффекта печати текста.")

    add "gui/menulabels/options.png"
    add "gui/prefs/pref_ground.png"
    $ tooltip = GetTooltip()
    if tooltip:
        text "[tooltip]" xpos 100 ypos 1015


style pref_label is gui_label
style pref_label_text is gui_label_text
style pref_vbox is vbox

style radio_label is pref_label
style radio_label_text is pref_label_text
style radio_button is gui_button
style radio_button_text is gui_button_text
style radio_vbox is pref_vbox

style check_label is pref_label
style check_label_text is pref_label_text
style check_button is gui_button
style check_button_text is gui_button_text
style check_vbox is pref_vbox

style slider_label is pref_label
style slider_label_text is pref_label_text
style slider_slider is gui_slider
style slider_button is gui_button
style slider_button_text is gui_button_text
style slider_pref_vbox is pref_vbox

style mute_all_button is check_button
style mute_all_button_text is check_button_text

style pref_label:
    top_margin gui.pref_spacing
    bottom_margin 3

style pref_label_text:
    yalign 1.0

style pref_vbox:
    xsize 338

style radio_vbox:
    spacing gui.pref_button_spacing

style radio_button:
    properties gui.button_properties("radio_button")
    foreground "gui/button/check_[prefix_]foreground.png"

style radio_button_text:
    properties gui.button_text_properties("radio_button")

style check_vbox:
    spacing gui.pref_button_spacing

style check_button:
    properties gui.button_properties("check_button")
    foreground "gui/button/check_[prefix_]foreground.png"

style check_button_text:
    properties gui.button_text_properties("check_button")

style slider_slider:
    xsize 525

style slider_button:
    properties gui.button_properties("slider_button")
    yalign 0.5
    left_margin 15

style slider_button_text:
    properties gui.button_text_properties("slider_button")

style slider_vbox:
    xsize 675










screen history():
    tag menu



    predict False

    use game_menu(_("History"), scroll=("vpgrid" if gui.history_height else "viewport")):
        style_prefix "history"

        for h in _history_list:
            window:


                has fixed:
                    yfit True

                if h.who:

                    label h.who:
                        style "history_name"



                        if "color" in h.who_args:
                            text_color h.who_args["color"]
                            text_outlines h.who_args["outlines"]


                text h.what

        if not _history_list:
            add "gui/historyback.png"
            label _("История диалогов пуста.")

    add "gui/menulabels/log.png"



style history_window is empty

style history_name is gui_label
style history_name_text is gui_label_text
style history_text is default

style history_label is gui_label
style history_label_text is gui_label_text

style history_window:
    xfill True
    ysize gui.history_height

style history_name:
    xpos gui.history_name_xpos
    xanchor gui.history_name_xalign
    ypos gui.history_name_ypos
    xsize gui.history_name_width

style history_name_text:
    min_width gui.history_name_width
    text_align gui.history_name_xalign
    size 35


style history_text:
    xpos gui.history_text_xpos
    ypos gui.history_text_ypos
    xanchor gui.history_text_xalign
    xsize gui.history_text_width
    min_width gui.history_text_width
    text_align gui.history_text_xalign
    layout ("subtitle" if gui.history_text_xalign else "tex")
    font gui.default_font
    size gui.text_size

style history_label:
    xfill True

style history_label_text:
    xalign 0.5








screen help():
    tag menu


    default device = "keyboard"

    use game_menu(_("Help"), scroll="viewport"):

        style_prefix "help"

        vbox:
            spacing 23

            hbox:

                textbutton _("Клавиатура") action SetScreenVariable("device", "keyboard")
                textbutton _("Мышь") action SetScreenVariable("device", "mouse")
                textbutton _("{font=DejaVuSans.ttf}⚠{/font} Небезопасное содержимое") action SetScreenVariable("device", "content_warning")

                if GamepadExists():
                    textbutton _("Гейпад") action SetScreenVariable("device", "gamepad")

            if device == "keyboard":
                use keyboard_help
            elif device == "mouse":
                use mouse_help
            elif device == "gamepad":
                use gamepad_help
            elif device == "content_warning":
                use content_help

    add "gui/menulabels/help.png"


screen keyboard_help():

    hbox:
        label _("Enter")
        text _("Продвижение по диалогу и выбор пунктов меню.")

    hbox:
        label _("Пробел")
        text _("Продвижение по диалогу (не выбирает варианты ответа).")

    hbox:
        label _("Стрелки")
        text _("Навигация по интерфейсу.")

    hbox:
        label _("Esc")
        text _("Меню игры.")

    hbox:
        label _("Ctrl")
        text _("Если зажать, то проматывает диалог.")

    hbox:
        label _("Tab")
        text _("Включает режим перемотки диалогов.")

    hbox:
        label _("Page Up")
        text _("Перематывает к прошлому диалогу.")

    hbox:
        label _("Page Down")
        text _("Перематывает к следующему диалогу.")

    hbox:
        label "H"
        text _("Скрывает интерфейс.")

    hbox:
        label "S"
        text _("Делает скриншот.")

    hbox:
        label "V"
        text _("Включает {a=https://www.renpy.org/l/voicing}голосовое сопровождение{/a}.")


screen mouse_help():

    hbox:
        label _("Левая кнопка мыши")
        text _("Продвижение по диалогу и выбор пунктов меню.")

    hbox:
        label _("Средняя кнопка мыши")
        text _("Скрывает интерфейс.")

    hbox:
        label _("Правая кнопка мыши")
        text _("Открывает меню игры.")

    hbox:
        label _("Кручение колёсика вверх")
        text _("Перематывает к прошлому диалогу.")

    hbox:
        label _("Кручение колёсика вниз")
        text _("Перематывает к следующему диалогу.")


screen gamepad_help():

    hbox:
        label _("Right Trigger\nA/Bottom Button")
        text _("Продвижение по диалогу и выбор пунктов меню.")

    hbox:
        label ("Left Trigger\nLeft Shoulder")
        text _("Перематывает к прошлому диалогу.")

    hbox:
        label _("Right Shoulder")
        text _("Перематывает к следующему диалогу.")

    hbox:
        label _("D-Pad, Sticks")
        text _("Навигация по интерфейсу.")

    hbox:
        label _("Start, Guide")
        text _("Меню игры.")

    hbox:
        label _("Y/Top Button")
        text _("Скрыть интерфейс.")

    textbutton _("Отрегулировать") action GamepadCalibrate()


style help_button is gui_button
style help_button_text is gui_button_text
style help_label is gui_label
style help_label_text is gui_label_text
style help_text is gui_text

style help_button:
    properties gui.button_properties("help_button")
    xmargin 12

style help_button_text:
    properties gui.button_text_properties("help_button")

style help_label:
    xsize 375
    right_padding 30

style help_label_text:
    size gui.text_size
    xalign 1.0
    text_align 1.0















screen confirm(message, yes_action, no_action):


    modal True

    zorder 200

    style_prefix "confirm"

    add "gui/overlay/confirm.png"
    add "gui/yesno_ground.png"

    imagebutton idle "gui/yes_idle.png" hover "gui/yes_hover.png" xpos 791 ypos 391 focus_mask None action yes_action
    imagebutton idle "gui/no_idle.png" hover "gui/no_hover.png" xpos 1046 ypos 392 focus_mask None action no_action

    vbox:
        xalign .5
        yalign .28
        spacing 45
        xmaximum 715


        label _(message):
            style "confirm_prompt"
            xalign 0.5



    key "game_menu" action no_action


style confirm_frame is gui_frame
style confirm_prompt is gui_prompt
style confirm_prompt_text is gui_prompt_text
style confirm_button is gui_medium_button
style confirm_button_text is gui_medium_button_text

style confirm_frame:
    background Frame([ "gui/confirm_frame.png", "gui/frame.png"], gui.confirm_frame_borders, tile=gui.frame_tile)
    padding gui.confirm_frame_borders.padding
    xalign .5
    yalign .5

style confirm_prompt_text:
    text_align 0.5
    layout "subtitle"
    outlines [ (absolute(3), "#1d1623", absolute(0), absolute(0)) ]
    size 30

style confirm_button:
    properties gui.button_properties("confirm_button")

style confirm_button_text:
    properties gui.button_text_properties("confirm_button")









screen skip_indicator():

    zorder 100
    style_prefix "skip"

    frame:

        has hbox:
            spacing 9

        text _("Skipping")

        text "▸" at delayed_blink(0.0, 1.0) style "skip_triangle"
        text "▸" at delayed_blink(0.2, 1.0) style "skip_triangle"
        text "▸" at delayed_blink(0.4, 1.0) style "skip_triangle"



transform delayed_blink(delay, cycle):
    alpha .5

    pause delay
    block:

        linear .2 alpha 1.0
        pause .2
        linear .2 alpha 0.5
        pause (cycle - .4)
        repeat


style skip_frame is empty
style skip_text is gui_text
style skip_triangle is skip_text

style skip_frame:
    ypos gui.skip_ypos
    background Frame("gui/skip.png", gui.skip_frame_borders, tile=gui.frame_tile)
    padding gui.skip_frame_borders.padding

style skip_text:
    size gui.notify_text_size

style skip_triangle:


    font "DejaVuSans.ttf"









screen notify(message):

    zorder 100
    style_prefix "notify"

    frame at notify_appear:
        text message

    timer 3.25 action Hide('notify')


transform notify_appear:
    on show:
        alpha 0
        linear .25 alpha 1.0
    on hide:
        linear .5 alpha 0.0


style notify_frame is empty
style notify_text is gui_text

style notify_frame:
    ypos gui.notify_ypos

    background Frame("gui/notify.png", gui.notify_frame_borders, tile=gui.frame_tile)
    padding gui.notify_frame_borders.padding

style notify_text:
    size gui.notify_text_size









screen nvl(dialogue, items=None):

    window:
        style "nvl_window"

        has vbox:
            spacing gui.nvl_spacing


        if gui.nvl_height:

            vpgrid:
                cols 1
                yinitial 1.0

                use nvl_dialogue(dialogue)

        else:

            use nvl_dialogue(dialogue)



        for i in items:

            textbutton i.caption:
                action i.action
                style "nvl_button"

    add SideImage() xalign 0.0 yalign 1.0



screen nvl_dialogue(dialogue):

    for d in dialogue:

        window:
            id d.window_id

            has fixed:
                yfit gui.nvl_height is None

            if d.who is not None:

                text d.who:
                    id d.who_id

            else:
                text d.what:
                    id d.what_id







define config.nvl_list_length = 6

style nvl_window is default
style nvl_entry is default

style nvl_label is say_label
style nvl_dialogue is say_dialogue

style nvl_button is button
style nvl_button_text is button_text

style nvl_window:
    xfill True
    yfill True

    background "gui/nvl.png"
    padding gui.nvl_borders.padding

style nvl_entry:
    xfill True
    ysize gui.nvl_height

style nvl_label:
    xpos gui.nvl_name_xpos
    xanchor gui.nvl_name_xalign
    ypos gui.nvl_name_ypos
    yanchor 0.0
    xsize gui.nvl_name_width
    min_width gui.nvl_name_width
    text_align gui.nvl_name_xalign

style nvl_dialogue:

    xalign 0.5

    ypos gui.nvl_text_ypos
    xsize gui.nvl_text_width
    min_width gui.nvl_text_width
    text_align gui.nvl_text_xalign

    layout ("subtitle" if gui.nvl_text_xalign else "tex")
    font gui.default_font
    size gui.text_size

style nvl_thought:
    xpos gui.nvl_thought_xpos
    xanchor gui.nvl_thought_xalign
    ypos gui.nvl_thought_ypos
    xsize gui.nvl_thought_width
    min_width gui.nvl_thought_width
    text_align gui.nvl_thought_xalign
    layout ("subtitle" if gui.nvl_text_xalign else "tex")

style nvl_button:
    properties gui.button_properties("nvl_button")
    xpos gui.nvl_button_xpos
    xanchor gui.nvl_button_xalign

style nvl_button_text:
    properties gui.button_text_properties("nvl_button")







style pref_vbox:
    variant "medium"
    xsize 675



screen quick_menu():
    variant "touch"

    zorder 100

    hbox:
        style_prefix "quick"

        xalign 0.5
        yalign 1.0

        textbutton _("Перемотка") action Skip() alternate Skip(fast=True, confirm=True)
        textbutton _("Меню") action ShowMenu()
        textbutton _("Авто") action Preference("auto-forward", "toggle")


style window:
    variant "small"
    background "gui/phone/textbox.png"

style nvl_window:
    variant "small"
    background "gui/phone/nvl.png"

style main_menu_frame:
    variant "small"
    background "gui/phone/overlay/main_menu.png"

style game_menu_outer_frame:
    variant "small"
    background "gui/phone/overlay/game_menu.png"

style game_menu_navigation_frame:
    variant "small"
    xsize 510

style game_menu_content_frame:
    variant "small"
    top_margin 0

style pref_vbox:
    variant "small"
    xsize 600

style slider_pref_vbox:
    variant "small"
    xsize None

style slider_pref_slider:
    variant "small"
    xsize 900
# Decompiled by unrpyc: https://github.com/CensoredUsername/unrpyc
