init -10 python:
    def darken_image(s):
        return im.MatrixColor(s, im.matrix.brightness(-.05))
    def bright_image(z):
        return im.MatrixColor(z, im.matrix.brightness(.5))

    config.displayable_prefix["dark"] = darken_image
    config.displayable_prefix["light"] = bright_image

image unlockedcrop = "light:gui/gallerycrops/lockedcrop.png"
image firstmeeting_crop = "gui/gallerycrops/firstmeeting.png"
image firstmeeting_crop_dark = "dark:gui/gallerycrops/firstmeeting.png"

image badend1_crop = "gui/gallerycrops/badend1.png"
image badend1b_crop = "gui/gallerycrops/badend1b.png"
image badend2_crop = "gui/gallerycrops/badend2.png"
image badend3_crop = "gui/gallerycrops/badend3.png"
image badend4_crop = "gui/gallerycrops/badend4.png"
image badend5_crop = "gui/gallerycrops/badend5.png"
image goodend1_crop = "gui/gallerycrops/goodend1.png"
image goodend2_crop = "gui/gallerycrops/goodend2.png"
image kiss1_crop = "gui/gallerycrops/kiss1.png"
image kiss2_crop = "gui/gallerycrops/kiss2.png"
image sleepover_crop = "dark:gui/gallerycrops/sleepover.png"

image badend1_crop_dark = "dark:gui/gallerycrops/badend1.png"
image badend1b_crop_dark = "dark:gui/gallerycrops/badend1b.png"
image badend2_crop_dark = "dark:gui/gallerycrops/badend2.png"
image badend3_crop_dark = "dark:gui/gallerycrops/badend3.png"
image badend4_crop_dark = "dark:gui/gallerycrops/badend4.png"
image badend5_crop_dark = "dark:gui/gallerycrops/badend5.png"
image goodend1_crop_dark = "dark:gui/gallerycrops/goodend1.png"
image goodend2_crop_dark = "dark:gui/gallerycrops/goodend2.png"
image kiss1_crop_dark = "dark:gui/gallerycrops/kiss1.png"
image kiss2_crop_dark = "dark:gui/gallerycrops/kiss2.png"
image sleepover_crop_dark = "dark:gui/gallerycrops/sleepover.png"
image sleepover_a = "sleepover_cg"
image sleepover_b = "sleepover_cg e_blush e_browdown c_blush e_open c_open"
image sleepover_c = "sleepover_cg e_away c_browdown c_closed c_sweat"



init python:
    def ending_reached(ending):
        if ending not in persistent.endings:
            persistent.endings.append(ending)
        if not persistent.promos_unlocked:
            unlock_promo()

    def unlock_promo():
        for promo_images in promo_image_list:
            renpy.show(promo_images)
            renpy.hide(promo_images)
        persistent.promos_unlocked = True

    gallery_page = 0
    closeup_page = 0
    maxnumx = 4
    maxnumy = 1
    maxthumbx = config.screen_width / (maxnumx + 1)
    maxthumby = config.screen_height / (maxnumy + 1)
    maxperpage = maxnumx * maxnumy

    class GalleryItem:
        def __init__(self, images, thumb):
            self.images = images
            self.thumb = thumb
            self.refresh_lock()
        
        def refresh_lock(self):
            for img in self.images:
                if not renpy.seen_image(img):
                    self.is_locked = True
                else:
                    self.is_locked = False


    gallery_items = []
    gallery_items.append(GalleryItem(["first meeting1", "first meeting2", "first meeting3","first meeting4"], ["firstmeeting_crop","firstmeeting_crop_dark"])) 
    gallery_items.append(GalleryItem(["sleepover_a","sleepover_b","sleepover_c"], ["sleepover_crop","sleepover_crop_dark"]))
    gallery_items.append(GalleryItem(["badend1","badend1b"], ["badend1_crop","badend1_crop_dark"]))
    gallery_items.append(GalleryItem(["badend2"], ["badend2_crop","badend2_crop_dark"]))
    gallery_items.append(GalleryItem(["badend3","badend3b"], ["badend3_crop","badend3_crop_dark"]))
    gallery_items.append(GalleryItem(["badend4"], ["badend4_crop","badend4_crop_dark"]))
    gallery_items.append(GalleryItem(["badend5"], ["badend5_crop","badend5_crop_dark"]))
    gallery_items.append(GalleryItem(["goodend1"], ["goodend1_crop","goodend1_crop_dark"]))
    gallery_items.append(GalleryItem(["goodend2"], ["goodend2_crop","goodend2_crop_dark"]))
    gallery_items.append(GalleryItem(["kiss1"], ["kiss1_crop","kiss1_crop_dark"]))
    gallery_items.append(GalleryItem(["kiss2"], ["kiss2_crop","kiss2_crop_dark"]))



image romance_crop = "gui/gallerycrops/romance.png"
image romance_crop_dark = "dark:gui/gallerycrops/romance.png"

image kv1_crop = "gui/gallerycrops/kv1.png"
image kv1_crop_dark = "dark:gui/gallerycrops/kv1.png"

image kv2_crop = "gui/gallerycrops/kv2.png"
image kv2_crop_dark = "dark:gui/gallerycrops/kv2.png"

define promo_image_list = ["romance","kv1","kv2"]

init python:
    gallery_items.append(GalleryItem(["romance"], ["romance_crop","romance_crop_dark"]))
    gallery_items.append(GalleryItem(["kv1"], ["kv1_crop","kv1_crop_dark"]))
    gallery_items.append(GalleryItem(["kv2"], ["kv2_crop","kv2_crop_dark"]))

screen extras_gallery:
    tag menu

    use extras_nav
    $ start = gallery_page * maxperpage
    $ end = min(start + maxperpage - 1, len(gallery_items) - 1)

    hbox:
        xalign 0.5
        yalign 0.65
        spacing 85

        for i in range(start, end + 1):

            $ gallery_items[i].refresh_lock()

            fixed:
                xsize 301 ysize 301
                if gallery_items[i].is_locked:
                    button:
                        action NullAction()
                        background Image("gui/gallerycrops/lockedcrop.png")
                        xsize 301 ysize 301
                        text "Не открыто" xalign 0.5 yalign 0.5 text_align 0.5







                else:
                    add "gui/gallerycrops/lockedcrop.png"
                    imagebutton hover gallery_items[i].thumb[0] idle gallery_items[i].thumb[1] action Show("gallery_closeup", None,gallery_items[i].images),With(Dissolve(0.2)) xalign 0.5 yalign 0.5




        for i in range(end - start + 1, maxperpage):
            null
    hbox:
        style_prefix "page"

        xalign 0.5
        yalign 0.9

        spacing gui.page_spacing

        textbutton _("<") action [SetVariable("gallery_page", gallery_page - 1), SensitiveIf((gallery_page > 0)),With(Dissolve(0.2)) ]


        for page in range(1, 5):
            textbutton "[page]" action SetVariable("gallery_page",page-1),With(Dissolve(0.2))

        textbutton _(">") action [SetVariable("gallery_page", gallery_page + 1), SensitiveIf((gallery_page + 1) * maxperpage < len(gallery_items)),With(Dissolve(0.2))]








default togglefit = False
screen gallery_closeup(images):
    default gallery_UI = True
    key "mouseup_3" action Hide("gallery_closeup"),With(Dissolve(0.15))
    key "K_BACKSPACE" action ToggleScreenVariable("gallery_UI", true_value=True,false_value=False),With(Dissolve(0.15))
    vbox:
        xsize 1920 xalign 0.5
        side "c":
            area (0, 0, 1920, 1080) xalign 0.5
            viewport id "vp":
                xalign 0.5
                draggable True
                yinitial 0.5
                xinitial 0.5
                if togglefit:
                    frame:
                        padding (0,0,0,0) xfill True yfill True background ("#100c13")
                        add images[closeup_page]:
                            xalign 0.5 yalign 0.5
                            maxsize (2000,1100)
                else:
                    add images[closeup_page]:
                        xalign 0.5 yalign 0.5

    if gallery_UI:
        if len(images) > 1:
            add "gui/quickmenu/quickmenu_base.png" xalign 1.0 yalign 0.0
        else:
            add "gui/quickmenu/quickmenu_base.png" xalign 1.2 yalign 0.0
        hbox:
            style_prefix "quick"

            xalign 0.925
            yalign 0.005
            spacing 15
            if togglefit:
                textbutton "Fit To Screen" action SetScreenVariable("togglefit",False),With(Dissolve(0.2)) xalign 0.5 text_align 0.5 text_xalign 0.5
            else:
                textbutton "Full Resolution" action SetScreenVariable("togglefit",True),With(Dissolve(0.2)) xalign 0.5 text_align 0.5 text_xalign 0.5
            if len(images) > 1:
                textbutton "Previous" action [SetScreenVariable("closeup_page", closeup_page - 1),SensitiveIf(closeup_page > 0),With(Dissolve(0.2))] xalign 0.5 text_align 0.5 text_xalign 0.5

                textbutton "Next" action [SetScreenVariable("closeup_page", closeup_page + 1),SensitiveIf(closeup_page < len(images) - 1),With(Dissolve(0.2))] xalign 0.5 text_align 0.5 text_xalign 0.5

            textbutton "Exit" action Hide("gallery_closeup"),With(Dissolve(0.2)) xalign 0.5 text_align 0.5 text_xalign 0.5
    hbox:
        xalign 0.995 yalign 0.0
        imagebutton idle "gui/quickmenu/ribbon_idle.png" hover "gui/quickmenu/ribbon_hover.png" focus_mask True action ToggleScreenVariable("gallery_UI", true_value=True,false_value=False)
        if gallery_UI:
            pass

        else:
            pass
# Decompiled by unrpyc: https://github.com/CensoredUsername/unrpyc
